/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.spnego;

import com.ning.http.client.providers.netty.spnego.SpnegoTokenGenerator;
import com.ning.http.util.Base64;
import java.io.IOException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpnegoEngine {
    private static final String SPNEGO_OID = "1.3.6.1.5.5.2";
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SpnegoTokenGenerator spnegoGenerator;
    private GSSContext gssContext = null;
    private byte[] token;
    private Oid negotiationOid = null;

    public SpnegoEngine(SpnegoTokenGenerator spnegoGenerator) {
        this.spnegoGenerator = spnegoGenerator;
    }

    public SpnegoEngine() {
        this(null);
    }

    public String generateToken(String server) throws Throwable {
        try {
            GSSName serverName;
            GSSManager manager;
            this.log.debug("init {}", (Object)server);
            this.negotiationOid = new Oid(SPNEGO_OID);
            boolean tryKerberos = false;
            try {
                manager = GSSManager.getInstance();
                serverName = manager.createName("HTTP@" + server, GSSName.NT_HOSTBASED_SERVICE);
                this.gssContext = manager.createContext(serverName.canonicalize(this.negotiationOid), this.negotiationOid, null, 0);
                this.gssContext.requestMutualAuth(true);
                this.gssContext.requestCredDeleg(true);
            }
            catch (GSSException ex) {
                this.log.error("generateToken", (Throwable)ex);
                if (ex.getMajor() == 2) {
                    this.log.debug("GSSException BAD_MECH, retry with Kerberos MECH");
                    tryKerberos = true;
                }
                throw ex;
            }
            if (tryKerberos) {
                this.log.debug("Using Kerberos MECH {}", (Object)KERBEROS_OID);
                this.negotiationOid = new Oid(KERBEROS_OID);
                manager = GSSManager.getInstance();
                serverName = manager.createName("HTTP@" + server, GSSName.NT_HOSTBASED_SERVICE);
                this.gssContext = manager.createContext(serverName.canonicalize(this.negotiationOid), this.negotiationOid, null, 0);
                this.gssContext.requestMutualAuth(true);
                this.gssContext.requestCredDeleg(true);
            }
            if (this.token == null) {
                this.token = new byte[0];
            }
            this.token = this.gssContext.initSecContext(this.token, 0, this.token.length);
            if (this.token == null) {
                throw new Exception("GSS security context initialization failed");
            }
            if (this.spnegoGenerator != null && this.negotiationOid.toString().equals(KERBEROS_OID)) {
                this.token = this.spnegoGenerator.generateSpnegoDERObject(this.token);
            }
            this.gssContext.dispose();
            String tokenstr = new String(Base64.encode(this.token));
            this.log.debug("Sending response '{}' back to the server", (Object)tokenstr);
            return tokenstr;
        }
        catch (GSSException gsse) {
            this.log.error("generateToken", (Throwable)gsse);
            if (gsse.getMajor() == 9 || gsse.getMajor() == 8) {
                throw new Exception(gsse.getMessage(), gsse);
            }
            if (gsse.getMajor() == 13) {
                throw new Exception(gsse.getMessage(), gsse);
            }
            if (gsse.getMajor() == 10 || gsse.getMajor() == 19 || gsse.getMajor() == 20) {
                throw new Exception(gsse.getMessage(), gsse);
            }
            throw new Exception(gsse.getMessage());
        }
        catch (IOException ex) {
            throw new Exception(ex.getMessage());
        }
    }
}

