/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;

public class LineRecordReader
implements RecordReader<LongWritable, Text> {
    private static final Log LOG = LogFactory.getLog((String)LineRecordReader.class.getName());
    private CompressionCodecFactory compressionCodecs = null;
    private long start;
    private long pos;
    private long end;
    private LineReader in;
    int maxLineLength;

    public LineRecordReader(Configuration job, FileSplit split) throws IOException {
        this(job, split, null);
    }

    public LineRecordReader(Configuration job, FileSplit split, byte[] recordDelimiter) throws IOException {
        this.maxLineLength = job.getInt("mapred.linerecordreader.maxlength", Integer.MAX_VALUE);
        this.start = split.getStart();
        this.end = this.start + split.getLength();
        Path file = split.getPath();
        this.compressionCodecs = new CompressionCodecFactory(job);
        CompressionCodec codec = this.compressionCodecs.getCodec(file);
        FileSystem fs = file.getFileSystem(job);
        FSDataInputStream fileIn = fs.open(split.getPath());
        boolean skipFirstLine = false;
        if (codec != null) {
            this.in = new LineReader((InputStream)codec.createInputStream(fileIn), job, recordDelimiter);
            this.end = Long.MAX_VALUE;
        } else {
            if (this.start != 0L) {
                skipFirstLine = true;
                --this.start;
                fileIn.seek(this.start);
            }
            this.in = new LineReader((InputStream)fileIn, job, recordDelimiter);
        }
        if (skipFirstLine) {
            this.start += (long)this.in.readLine(new Text(), 0, (int)Math.min(Integer.MAX_VALUE, this.end - this.start));
        }
        this.pos = this.start;
    }

    public LineRecordReader(InputStream in, long offset, long endOffset, int maxLineLength) {
        this(in, offset, endOffset, maxLineLength, null);
    }

    public LineRecordReader(InputStream in, long offset, long endOffset, int maxLineLength, byte[] recordDelimiter) {
        this.maxLineLength = maxLineLength;
        this.in = new LineReader(in, recordDelimiter);
        this.start = offset;
        this.pos = offset;
        this.end = endOffset;
    }

    public LineRecordReader(InputStream in, long offset, long endOffset, Configuration job) throws IOException {
        this(in, offset, endOffset, job, null);
    }

    public LineRecordReader(InputStream in, long offset, long endOffset, Configuration job, byte[] recordDelimiter) throws IOException {
        this.maxLineLength = job.getInt("mapred.linerecordreader.maxlength", Integer.MAX_VALUE);
        this.in = new LineReader(in, job, recordDelimiter);
        this.start = offset;
        this.pos = offset;
        this.end = endOffset;
    }

    @Override
    public LongWritable createKey() {
        return new LongWritable();
    }

    @Override
    public Text createValue() {
        return new Text();
    }

    @Override
    public synchronized boolean next(LongWritable key, Text value) throws IOException {
        while (this.pos < this.end) {
            key.set(this.pos);
            int newSize = this.in.readLine(value, this.maxLineLength, Math.max((int)Math.min(Integer.MAX_VALUE, this.end - this.pos), this.maxLineLength));
            if (newSize == 0) {
                return false;
            }
            this.pos += (long)newSize;
            if (newSize < this.maxLineLength) {
                return true;
            }
            LOG.info((Object)("Skipped line of size " + newSize + " at pos " + (this.pos - (long)newSize)));
        }
        return false;
    }

    @Override
    public float getProgress() {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.pos - this.start) / (float)(this.end - this.start));
    }

    @Override
    public synchronized long getPos() throws IOException {
        return this.pos;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    @Deprecated
    public static class LineReader
    extends org.apache.hadoop.util.LineReader {
        LineReader(InputStream in) {
            super(in);
        }

        LineReader(InputStream in, int bufferSize) {
            super(in, bufferSize);
        }

        public LineReader(InputStream in, Configuration conf) throws IOException {
            super(in, conf);
        }

        LineReader(InputStream in, byte[] recordDelimiter) {
            super(in, recordDelimiter);
        }

        LineReader(InputStream in, int bufferSize, byte[] recordDelimiter) {
            super(in, bufferSize, recordDelimiter);
        }

        public LineReader(InputStream in, Configuration conf, byte[] recordDelimiter) throws IOException {
            super(in, conf, recordDelimiter);
        }
    }
}

