/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.state;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.xml.namespace.QName;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourcePropertyProxy;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertyMetaData;
import org.globus.wsrf.impl.ReflectionResourceProperty;
import org.globus.wsrf.impl.SimpleResourceProperty;
import org.globus.wsrf.impl.SimpleResourcePropertyMetaData;
import org.globus.wsrf.impl.SimpleResourcePropertySet;

public class GCUBEWSResourcePropertySet
extends SimpleResourcePropertySet {
    public static final String PROVIDER_NS = "http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider";
    private ResourceProperty serviceID;
    public static final String RP_SID_NAME = "ServiceID";
    private ResourceProperty serviceName;
    public static final String RP_SNAME_NAME = "ServiceName";
    private ResourceProperty serviceClass;
    public static final String RP_SCLASS_NAME = "ServiceClass";
    private ResourceProperty RI;
    public static final String RP_RIID_NAME = "RI";
    private ResourceProperty GHN;
    public static final String RP_GID_NAME = "GHN";
    private ResourceProperty scope;
    public static final String RP_SCOPES_NAME = "Scope";
    private ResourceProperty terminationTime;
    private ResourceProperty currentTime;
    protected volatile GCUBEStatefulPortTypeContext context;
    private Observable producer = new RPSetChangeProducer();
    protected GCUBELog logger = new GCUBELog(GCUBEWSResourcePropertySet.class);

    public GCUBEWSResourcePropertySet(GCUBEWSResource resource) throws Exception {
        super(new QName(resource.getPorttypeContext().getNamespace(), resource.getPorttypeContext().getRPDName()));
        this.context = resource.getPorttypeContext();
        this.logger.setContext(this.context.getServiceContext());
        this.serviceID = new SimpleResourceProperty(new QName(PROVIDER_NS, RP_SID_NAME));
        this.serviceName = new SimpleResourceProperty(new QName(PROVIDER_NS, RP_SNAME_NAME));
        this.serviceClass = new SimpleResourceProperty(new QName(PROVIDER_NS, RP_SCLASS_NAME));
        this.RI = new SimpleResourceProperty(new QName(PROVIDER_NS, RP_RIID_NAME));
        this.GHN = new SimpleResourceProperty(new QName(PROVIDER_NS, RP_GID_NAME));
        this.scope = new SimpleResourceProperty(new QName(PROVIDER_NS, RP_SCOPES_NAME));
        this.currentTime = new ReflectionResourceProperty((ResourcePropertyMetaData)SimpleResourcePropertyMetaData.CURRENT_TIME, (Object)this);
        this.terminationTime = new SimpleResourceProperty((ResourcePropertyMetaData)SimpleResourcePropertyMetaData.TERMINATION_TIME);
        super.add(this.RI);
        super.add(this.serviceID);
        super.add(this.serviceName);
        super.add(this.GHN);
        super.add(this.serviceClass);
        super.add(this.scope);
        super.add(this.currentTime);
        super.add(this.terminationTime);
        this.setGHN(GHNContext.getContext().getGHNID());
        this.setServiceID(this.context.getServiceContext().getID());
        this.setServiceName(this.context.getServiceContext().getName());
        this.setServiceClass(this.context.getServiceContext().getServiceClass());
        this.setRI(this.context.getServiceContext().getInstance().getID());
        this.setTerminationTime(Calendar.getInstance());
    }

    public ResourceProperty get(String name) {
        return this.get(new QName(this.context.getNamespace(), name));
    }

    public ResourceProperty getSystemRP(String name) {
        return this.get(new QName(PROVIDER_NS, name));
    }

    public Calendar getCurrentTime() {
        return Calendar.getInstance();
    }

    public synchronized Calendar getTerminationTime() {
        return (Calendar)this.terminationTime.get(0);
    }

    public synchronized void setTerminationTime(Calendar calendar) {
        this.terminationTime.clear();
        this.terminationTime.add((Object)calendar);
    }

    public synchronized String getRI() {
        return (String)this.RI.get(0);
    }

    public synchronized void setRI(String id) {
        this.RI.clear();
        this.RI.add((Object)id);
    }

    public synchronized String getServiceID() {
        return (String)this.serviceID.get(0);
    }

    public synchronized void setServiceID(String id) {
        this.serviceID.clear();
        this.serviceID.add((Object)id);
    }

    public synchronized String getGHN() {
        return (String)this.GHN.get(0);
    }

    public synchronized void setGHN(String id) {
        this.GHN.clear();
        this.GHN.add((Object)id);
    }

    public synchronized void setServiceName(String name) {
        this.serviceName.clear();
        this.serviceName.add((Object)name);
    }

    public synchronized String getServiceName() {
        return (String)this.serviceName.get(0);
    }

    public synchronized void setServiceClass(String serviceclass) {
        this.serviceClass.clear();
        this.serviceClass.add((Object)serviceclass);
    }

    public synchronized String getServiceClass() {
        return (String)this.serviceClass.get(0);
    }

    public synchronized void setScope(List<String> scopes) {
        if (scopes == null) {
            return;
        }
        this.scope.clear();
        for (String scope : scopes) {
            if (scope == null) continue;
            this.scope.add((Object)scope);
        }
    }

    public synchronized List<String> getScope() {
        ArrayList<String> scopes = new ArrayList<String>();
        Iterator i = this.scope.iterator();
        while (i.hasNext()) {
            scopes.add((String)i.next());
        }
        return scopes;
    }

    public synchronized boolean addScope(GCUBEScope scope) {
        if (scope == null) {
            throw new GCUBEScopeManager.IllegalScopeException();
        }
        List<String> scopes = this.getScope();
        if (scopes.contains(scope.toString())) {
            return false;
        }
        this.scope.add((Object)scope.toString());
        return true;
    }

    public synchronized boolean removeScope(GCUBEScope scope) {
        if (scope == null) {
            throw new GCUBEScopeManager.IllegalScopeException();
        }
        boolean removed = false;
        Iterator i = this.scope.iterator();
        while (i.hasNext()) {
            if (!((String)i.next()).equals(scope.toString())) continue;
            i.remove();
            removed = true;
            break;
        }
        return removed;
    }

    public static String[] getSystemRPNames() {
        return new String[]{SimpleResourcePropertyMetaData.TERMINATION_TIME.getName().getLocalPart(), SimpleResourcePropertyMetaData.CURRENT_TIME.getName().getLocalPart(), RP_GID_NAME, RP_RIID_NAME, RP_SCLASS_NAME, RP_SCOPES_NAME, RP_SID_NAME, RP_SNAME_NAME};
    }

    public boolean add(ResourceProperty prop) {
        boolean ret = super.add(prop);
        this.producer.notifyObservers(new RPSetChange(prop, GCUBEWSResourcePropertyProxy.ResourcePropertyEvent.CREATED));
        return ret;
    }

    public void deleteObserver(Observer o) {
        this.producer.deleteObserver(o);
    }

    public synchronized void addObserver(Observer o) {
        this.producer.addObserver(o);
    }

    protected void notifyObservers(final RPSetChange change) {
        new Thread("RPSetNotifier"){

            @Override
            public void run() {
                GCUBEWSResourcePropertySet.this.producer.notifyObservers(change);
            }
        }.start();
    }

    public void clear() {
        super.clear();
        this.notifyObservers(new RPSetChange(null, GCUBEWSResourcePropertyProxy.ResourcePropertyEvent.DELETED));
    }

    class RPSetChangeProducer
    extends Observable {
        RPSetChangeProducer() {
        }

        @Override
        public void notifyObservers() {
            this.setChanged();
            super.notifyObservers();
        }

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    }

    public class RPSetChange {
        private ResourceProperty resourceProperty;
        private GCUBEWSResourcePropertyProxy.ResourcePropertyEvent event;

        public RPSetChange(ResourceProperty rp, GCUBEWSResourcePropertyProxy.ResourcePropertyEvent event) {
            this.resourceProperty = rp;
            this.event = event;
        }

        public ResourceProperty getResourceProperty() {
            return this.resourceProperty;
        }

        public GCUBEWSResourcePropertyProxy.ResourcePropertyEvent getEvent() {
            return this.event;
        }
    }
}

