/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.map.ReferenceMap;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.service.Consumer;
import org.gcube.common.core.persistence.GCUBENoPersistenceDelegate;
import org.gcube.common.core.persistence.GCUBEPersistenceDelegate;
import org.gcube.common.core.state.GCUBEReadWriteLock;
import org.gcube.common.core.state.GCUBEStatefulResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.wsrf.InvalidResourceKeyException;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.jndi.Initializable;
import org.globus.wsrf.utils.cache.LRUCache;

public abstract class GCUBEResourceHome<LEGACYID, RESOURCEID extends LEGACYID, RESOURCE extends GCUBEStatefulResource<RESOURCEID>>
implements Initializable {
    protected final GCUBELog logger = new GCUBELog(this);
    private boolean initialized;
    protected volatile Class<RESOURCE> resourceClass;
    protected volatile GCUBEPersistenceDelegate<RESOURCEID, RESOURCE> persistenceDelegate;
    protected volatile Mode mode = Mode.TRANSIENT;
    private final int UNDEFINED_TIMEOUT = -1;
    private final int INFINITE_TIMEOUT = 0;
    private volatile long cacheTimeout = -1L;
    private volatile Map<RESOURCEID, RESOURCE> resources;
    protected volatile LRUCache cache;
    protected final LockManager lockManager = new LockManager();
    protected final List<RESOURCEID> resourceLog = Collections.synchronizedList(new ArrayList());

    public final synchronized void initialize() throws Exception {
        if (this.initialized || this.getServiceContext().getStatus() == GCUBEServiceContext.Status.FAILED) {
            return;
        }
        this.getServiceContext().subscribeLifetTime(new HomeConsumer(), new GCUBEServiceContext.RILifetimeTopic[0]);
        this.initialized = true;
    }

    public synchronized void setResourceClass(String clazz) throws ClassNotFoundException {
        if (this.resourceClass != null) {
            throw new RuntimeException("resource class already configured");
        }
        Class<?> resourceClass = this.getClass().getClassLoader().loadClass(clazz);
        this.resourceClass = resourceClass;
    }

    public synchronized String getResourceClass() {
        return this.resourceClass.getName();
    }

    public synchronized void setPersistenceDelegateClass(String clazz) throws Exception {
        if (this.persistenceDelegate != null) {
            throw new RuntimeException("persistence delegate already configured");
        }
        Class<?> delegateClass = this.getClass().getClassLoader().loadClass(clazz);
        this.persistenceDelegate = (GCUBEPersistenceDelegate)delegateClass.newInstance();
    }

    public synchronized void setCacheTimeout(long timeout) {
        if (this.cacheTimeout != -1L) {
            throw new RuntimeException("cache timeout already configured");
        }
        this.cacheTimeout = timeout;
    }

    public abstract GCUBEServiceContext getServiceContext();

    protected void onInitialisation() throws Exception {
        if (this.resourceClass == null) {
            throw new Exception("resource class is not configured");
        }
        if (this.persistenceDelegate == null) {
            if (this.cacheTimeout != -1L) {
                throw new Exception("cache is configured but persistence delegate is not");
            }
            this.persistenceDelegate = new GCUBENoPersistenceDelegate<RESOURCE>();
        } else {
            this.mode = this.cacheTimeout == -1L ? Mode.SOFTPERSISTENT : (this.cacheTimeout == 0L ? Mode.HARDPERSISTENT : Mode.CACHEDPERSISTENT);
        }
        this.persistenceDelegate.initialise(this);
        this.logger.info("managing resources in " + (Object)((Object)this.mode) + " mode");
        if (this.mode == Mode.TRANSIENT || this.mode == Mode.HARDPERSISTENT) {
            this.resources = new HashMap<RESOURCEID, RESOURCE>();
        } else {
            this.resources = new ReferenceMap(0, 1, true);
            if (this.mode == Mode.CACHEDPERSISTENT) {
                this.cache = new LRUCache();
                this.cache.setTimeout(this.cacheTimeout);
                this.cache.initialize();
            }
        }
        this.resources = Collections.synchronizedMap(this.resources);
        if (this.mode != Mode.TRANSIENT) {
            for (RESOURCEID id : this.persistenceDelegate.getResourceIdentifiers()) {
                try {
                    this.find(id);
                }
                catch (Exception e) {
                    this.logger.warn("could not first-load resource " + id, e);
                }
            }
        }
    }

    protected void onReady() throws Exception {
    }

    protected void onUpdate() throws Exception {
    }

    protected void onStateChange() throws Exception {
    }

    protected void onFailure() throws Exception {
    }

    protected RESOURCE newInstance() throws ResourceException {
        try {
            return (RESOURCE)((GCUBEStatefulResource)this.resourceClass.newInstance());
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(RESOURCE resource) {
        Map<RESOURCEID, RESOURCE> map = this.resources;
        synchronized (map) {
            this.resources.put(((GCUBEStatefulResource)resource).getID(), resource);
            if (!this.resourceLog.contains(((GCUBEStatefulResource)resource).getID())) {
                this.resourceLog.add(((GCUBEStatefulResource)resource).getID());
            }
            if (this.mode == Mode.CACHEDPERSISTENT) {
                this.cache.update(resource);
            }
        }
    }

    protected RESOURCE get(LEGACYID id) throws ResourceException, NoSuchResourceException {
        GCUBEStatefulResource<Object> resource = (GCUBEStatefulResource)this.resources.get(id);
        if (resource == null) {
            if (this.mode == Mode.TRANSIENT) {
                throw new NoSuchResourceException();
            }
            resource = this.newInstance();
            this.preInitialise(resource);
            resource.setID(id);
            boolean firstLoad = !this.resourceLog.contains(id);
            try {
                this.persistenceDelegate.load(resource, firstLoad);
            }
            catch (NoSuchResourceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ResourceException((Throwable)e);
            }
            this.onLoad(resource, firstLoad);
            this.add(resource);
        } else if (this.mode == Mode.CACHEDPERSISTENT) {
            this.cache.update((Object)resource);
        }
        return (RESOURCE)resource;
    }

    protected void remove(RESOURCE resource) throws ResourceException {
        GCUBEReadWriteLock.GCUBEWriteLock lock = ((GCUBEStatefulResource)resource).getLock().writeLock();
        try {
            lock.lockPreemptively();
        }
        catch (InterruptedException e) {
            throw new NoSuchResourceException();
        }
        try {
            if (this.onRemove(resource)) {
                ((GCUBEStatefulResource)resource).onRemove();
                this.resources.remove(((GCUBEStatefulResource)resource).getID());
                this.resourceLog.remove(((GCUBEStatefulResource)resource).getID());
                if (this.mode == Mode.CACHEDPERSISTENT) {
                    this.cache.remove(resource);
                }
                this.persistenceDelegate.remove(resource);
            } else {
                lock.cancelPreemptive();
            }
        }
        catch (Exception e) {
            lock.cancelPreemptive();
            throw new ResourceException("could not remove resource " + ((GCUBEStatefulResource)resource).getID(), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<? extends RESOURCE> getResources() {
        Map<RESOURCEID, RESOURCE> map = this.resources;
        synchronized (map) {
            return new HashSet<RESOURCE>(this.resources.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends RESOURCEID> getIdentifiers() {
        if (this.mode == Mode.TRANSIENT || this.mode == Mode.HARDPERSISTENT) {
            Map<RESOURCEID, RESOURCE> map = this.resources;
            synchronized (map) {
                return new HashSet<RESOURCEID>(this.resources.keySet());
            }
        }
        return this.persistenceDelegate.getResourceIdentifiers();
    }

    public RESOURCE create(Object ... params) throws ResourceException {
        return this.createInternal(null, params);
    }

    public RESOURCE create(RESOURCEID id, Object ... params) throws ResourceException {
        RESOURCE resource;
        if (id == null) {
            throw new ResourceException("identifier is missing");
        }
        try {
            resource = this.reuse(id, params);
            this.onReuse(resource);
        }
        catch (NoSuchResourceException e) {
            resource = this.createInternal(id, params);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RESOURCE reuse(RESOURCEID id, Object ... params) throws ResourceException {
        RESOURCE resource = null;
        ReentrantLock lock = this.lockManager.getLock(id);
        try {
            lock.lock();
            resource = this.get(id);
        }
        finally {
            lock.unlock();
        }
        return resource;
    }

    protected RESOURCE createInternal(RESOURCEID id, Object ... params) throws ResourceException {
        this.logger.info("creating a " + this.resourceClass.getSimpleName());
        RESOURCE resource = this.newInstance();
        this.preInitialise(resource);
        try {
            ((GCUBEStatefulResource)resource).initialise(id, params);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
        this.postInitialise(resource);
        this.add(resource);
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RESOURCE find(LEGACYID id) throws ResourceException, NoSuchResourceException {
        if (id == null) {
            throw new ResourceException("resource identifier is missing");
        }
        ReentrantLock lock = this.lockManager.getLock(id);
        try {
            lock.lock();
            RESOURCE RESOURCE = this.get(id);
            return RESOURCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(LEGACYID id) throws ResourceException {
        if (id == null) {
            throw new InvalidResourceKeyException("resource identifier is missing");
        }
        ReentrantLock lock = this.lockManager.getLock(id);
        try {
            lock.lock();
            this.remove((LEGACYID)this.get(id));
        }
        finally {
            lock.unlock();
        }
    }

    protected void preInitialise(RESOURCE resource) throws ResourceException {
        try {
            ((GCUBEStatefulResource)resource).setPersistenceDelegate(this.persistenceDelegate);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    protected void postInitialise(RESOURCE resource) throws ResourceException {
        this.logger.trace("post-initialising " + this.resourceClass.getSimpleName() + "(" + ((GCUBEStatefulResource)resource).getID() + ")");
    }

    protected void onReuse(RESOURCE resource) throws ResourceException {
        this.logger.info("reusing a " + this.resourceClass.getSimpleName() + "(" + ((GCUBEStatefulResource)resource).getID() + ")");
    }

    protected void onLoad(RESOURCE resource, boolean firstLoad) throws ResourceException {
    }

    protected boolean onRemove(RESOURCE resource) throws ResourceException {
        this.logger.info("removing a " + this.resourceClass.getSimpleName() + "(" + ((GCUBEStatefulResource)resource).getID() + ")");
        return true;
    }

    class LockManager {
        Map<LEGACYID, ReentrantLock> locks = new ReferenceMap(0, 1, true);

        LockManager() {
        }

        public synchronized ReentrantLock getLock(LEGACYID key) {
            ReentrantLock lock = this.locks.get(key);
            if (lock == null) {
                lock = new ReentrantLock();
                this.locks.put(key, lock);
            }
            return lock;
        }
    }

    private class HomeConsumer
    extends Consumer {
        HomeConsumer() {
            this.consumerLogger = GCUBEResourceHome.this.logger;
        }

        @Override
        protected void onRIInitialised(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
            super.onRIInitialised(event);
            GCUBEResourceHome.this.logger.setContext(GCUBEResourceHome.this.getServiceContext());
            GCUBEResourceHome.this.logger.trace("INITIALISING " + GCUBEResourceHome.this.getClass().getSimpleName().toUpperCase());
            GCUBEResourceHome.this.onInitialisation();
        }

        @Override
        protected void onRIReady(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
            super.onRIReady(event);
            GCUBEResourceHome.this.onReady();
        }

        @Override
        protected void onRIStateChange(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
            super.onRIStateChange(event);
            GCUBEResourceHome.this.onStateChange();
        }

        @Override
        protected void onRIUpdated(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
            super.onRIUpdated(event);
            GCUBEResourceHome.this.onUpdate();
        }

        @Override
        protected void onRIFailed(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
            super.onRIFailed(event);
            GCUBEResourceHome.this.onFailure();
        }
    }

    protected static enum Mode {
        TRANSIENT,
        SOFTPERSISTENT,
        CACHEDPERSISTENT,
        HARDPERSISTENT;

    }
}

