/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.security.impl.authentication.extendedhandlers;

import java.util.List;
import java.util.Vector;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.gcube.common.core.security.impl.authentication.extendedhandlers.ExtendedDescriptorHandler;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.util.I18n;
import org.globus.wsrf.config.ConfigException;
import org.globus.wsrf.impl.security.authentication.AuthHandler;
import org.globus.wsrf.impl.security.authentication.DescriptorHandler;
import org.globus.wsrf.impl.security.authentication.RunAsHandler;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSException;

public class ExtendedSecurityPolicyHandler
extends ExtendedDescriptorHandler {
    private static final long serialVersionUID = 1L;
    private static List<DescriptorHandler> handlers = new Vector<DescriptorHandler>();
    protected static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.authentication.errors");

    @Override
    public void handle(MessageContext msgCtx, ResourceSecurityDescriptor resDesc, ServiceSecurityDescriptor desc, String servicePath) throws AxisFault {
        ExtendedGSSContext context = (ExtendedGSSContext)msgCtx.getProperty("org.globus.security.transport.context");
        if (context != null) {
            String rejectLimProxy = null;
            if (resDesc != null) {
                rejectLimProxy = resDesc.getRejectLimitedProxyState();
            }
            if (rejectLimProxy == null && desc != null) {
                rejectLimProxy = desc.getRejectLimitedProxyState();
            }
            if (rejectLimProxy == null) {
                ContainerSecurityDescriptor containerDesc = null;
                try {
                    containerDesc = ContainerSecurityConfig.getConfig().getSecurityDescriptor();
                }
                catch (ConfigException exp) {
                    throw AxisFault.makeFault((Exception)((Object)exp));
                }
                if (containerDesc != null) {
                    rejectLimProxy = containerDesc.getRejectLimitedProxyState();
                }
            }
            if (rejectLimProxy != null && rejectLimProxy.equals("true")) {
                Boolean receivedLimited = null;
                try {
                    receivedLimited = (Boolean)context.inquireByOid(GSSConstants.RECEIVED_LIMITED_PROXY);
                }
                catch (GSSException exp) {
                    AxisFault.makeFault((Exception)exp);
                }
                if (Boolean.TRUE.equals(receivedLimited)) {
                    throw new AxisFault(i18n.getMessage("rejectLimitedProxy"));
                }
            }
        }
        int size = handlers.size();
        for (int i = 0; i < size; ++i) {
            DescriptorHandler handler = handlers.get(i);
            handler.handle(msgCtx, resDesc, desc, servicePath);
        }
    }

    static {
        handlers.add((DescriptorHandler)new AuthHandler());
        handlers.add((DescriptorHandler)new RunAsHandler());
    }
}

