/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.security.context.impl;

import javax.security.auth.Subject;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBEServiceSecurityManager;
import org.gcube.common.core.security.context.impl.DefaultGHNSecurityContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityDescriptor;
import org.ietf.jgss.GSSCredential;

public class DefaultGHNServerSecurityContext
extends DefaultGHNSecurityContext {
    private GCUBELog logger = new GCUBELog(this);

    public DefaultGHNServerSecurityContext() {
        this.init();
    }

    private void init() {
        this.logger.debug("Loading server mode default security configuration");
        String pathToDefaultSecurityConfiguration = ContainerConfig.getConfig().getOption("defaultSecurityConfiguration");
        super.init(pathToDefaultSecurityConfiguration);
    }

    @Override
    public GSSCredential getDefaultCredentials() {
        if (this.defaultCredentials == null) {
            try {
                Subject systemSubject = this.getDefaultSubject();
                this.logger.debug("subject = " + systemSubject);
                this.defaultCredentials = JaasGssUtil.getCredential((Subject)systemSubject);
            }
            catch (Exception e) {
                this.logger.error("Unable to load container credentials, some operations could be not available", e);
            }
        }
        return this.defaultCredentials;
    }

    @Override
    public Subject getDefaultSubject() {
        if (this.defaultSubject == null) {
            try {
                this.logger.debug("Loading server mode container credentials");
                ContainerSecurityDescriptor containerDescriptor = ContainerSecurityConfig.getConfig().getSecurityDescriptor();
                this.defaultSubject = containerDescriptor.getSubject();
            }
            catch (Exception e) {
                this.logger.error("Unable to load container credentials, some operations could be not available", e);
            }
        }
        return this.defaultSubject;
    }

    @Override
    public GCUBESecurityManager getDefaultSecurityManager() throws Exception {
        this.logger.debug("Generate default security manager");
        this.logger.debug("Server mode: generating a Service security manager");
        Class<GCUBEServiceSecurityManager> securityManagerClass = GCUBEServiceSecurityManager.class;
        return GHNContext.getImplementation(securityManagerClass);
    }
}

