/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.security.context.impl;

import java.io.File;
import javax.security.auth.Subject;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.security.GCUBEDefaultSecurityConfiguration;
import org.gcube.common.core.security.context.SecurityContext;
import org.gcube.common.core.security.impl.GCUBECredentialAdder;
import org.gcube.common.core.security.utils.DefaultSecurityDescriptorBuilder;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;
import org.ietf.jgss.GSSCredential;

public abstract class DefaultGHNSecurityContext
implements SecurityContext {
    private GCUBELog logger = new GCUBELog(this);
    protected DefaultSecurityDescriptorBuilder defaultSecurityDescriptorBuilder;
    protected GSSCredential defaultCredentials;
    protected Subject defaultSubject;

    protected void init(String pathToDefaultSecurityConfiguration) {
        if (pathToDefaultSecurityConfiguration != null) {
            pathToDefaultSecurityConfiguration = GHNContext.getContext().getLocation() + File.separatorChar + pathToDefaultSecurityConfiguration;
            this.logger.debug("Default security configuration " + pathToDefaultSecurityConfiguration);
            try {
                this.defaultSecurityDescriptorBuilder = new DefaultSecurityDescriptorBuilder(pathToDefaultSecurityConfiguration);
            }
            catch (Exception e) {
                this.logger.error("Invalid default security configuration", e);
            }
        }
    }

    @Override
    public GCUBEDefaultSecurityConfiguration getDefaultServiceSecurityConfiguration() {
        if (this.defaultSecurityDescriptorBuilder != null) {
            return this.defaultSecurityDescriptorBuilder.getGCUBEDefaultSecurityConfiguration();
        }
        return null;
    }

    @Override
    public ServiceSecurityDescriptor getDefaultIncomingMessagesSecurityDescriptor() {
        if (this.defaultSecurityDescriptorBuilder != null) {
            return this.defaultSecurityDescriptorBuilder.getIncomingMessagesSecurityDescriptor();
        }
        return null;
    }

    @Override
    public ServiceSecurityDescriptor getDefaultOutgoingMessagesSecurityDescriptor() {
        if (this.defaultSecurityDescriptorBuilder != null) {
            return this.defaultSecurityDescriptorBuilder.getOutgoingMessagesSecurityDescriptor();
        }
        return null;
    }

    @Override
    public GCUBECredentialAdder getCredentialsAdder() {
        return new GCUBECredentialAdder();
    }
}

