/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.persistence;

import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.List;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.persistence.GCUBEFilePersistenceDelegate;
import org.gcube.common.core.state.GCUBEResourceHome;
import org.gcube.common.core.state.GCUBEStatefulResource;
import org.gcube.common.core.state.GCUBEWSHome;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;

public class GCUBEWSFilePersistenceDelegate<RESOURCE extends GCUBEWSResource>
extends GCUBEFilePersistenceDelegate<GCUBEWSResourceKey, RESOURCE> {
    protected static final String WSRESOURCE_FILE_SUFFIX = ".wsresource";
    protected volatile GCUBEStatefulPortTypeContext ctxt;

    @Override
    public void initialise(GCUBEResourceHome<? super GCUBEWSResourceKey, GCUBEWSResourceKey, RESOURCE> home) throws Exception {
        Class<?> resourceClass = this.getClass().getClassLoader().loadClass(home.getResourceClass());
        if (!GCUBEWSResource.class.isAssignableFrom(resourceClass)) {
            throw new Exception(home.getResourceClass() + " is not compatible with delegate " + this.getClass().getSimpleName());
        }
        super.initialise(home);
        this.ctxt = ((GCUBEWSHome)home).getPortTypeContext();
    }

    @Override
    protected void onLoad(RESOURCE resource, ObjectInputStream stream) throws Exception {
        super.onLoad(resource, stream);
        ((GCUBEWSResource)resource).getResourcePropertySet().setGHN((String)stream.readObject());
        ((GCUBEWSResource)resource).getResourcePropertySet().setServiceID((String)stream.readObject());
        ((GCUBEWSResource)resource).getResourcePropertySet().setServiceName((String)stream.readObject());
        ((GCUBEWSResource)resource).getResourcePropertySet().setServiceClass((String)stream.readObject());
        ((GCUBEWSResource)resource).getResourcePropertySet().setRI((String)stream.readObject());
        ((GCUBEWSResource)resource).getResourcePropertySet().setScope((List)stream.readObject());
        ((GCUBEWSResource)resource).getResourcePropertySet().setTerminationTime((Calendar)stream.readObject());
    }

    @Override
    protected void onStore(RESOURCE resource, ObjectOutputStream stream) throws Exception {
        super.onStore(resource, stream);
        stream.writeObject(((GCUBEWSResource)resource).getResourcePropertySet().getGHN());
        stream.writeObject(((GCUBEWSResource)resource).getResourcePropertySet().getServiceID());
        stream.writeObject(((GCUBEWSResource)resource).getResourcePropertySet().getServiceName());
        stream.writeObject(((GCUBEWSResource)resource).getResourcePropertySet().getServiceClass());
        stream.writeObject(((GCUBEWSResource)resource).getResourcePropertySet().getRI());
        stream.writeObject(((GCUBEWSResource)resource).getResourcePropertySet().getScope());
        stream.writeObject(((GCUBEWSResource)resource).getTerminationTime());
    }

    @Override
    protected String getSuffix() {
        return WSRESOURCE_FILE_SUFFIX;
    }

    @Override
    protected File getFileFromResource(RESOURCE resource) {
        return new File(this.getStorageRoot(), ((GCUBEWSResourceKey)((GCUBEStatefulResource)resource).getID()).getValue() + this.getSuffix());
    }

    @Override
    protected GCUBEWSResourceKey getIDFromFileName(String s) {
        return this.ctxt.makeKey(s);
    }
}

