/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.instrumentation;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.instrumentation.GHNMBean;
import org.gcube.common.core.instrumentation.GHNNotification;
import org.gcube.common.core.scope.GCUBEScope;

public class GHN
extends NotificationBroadcasterSupport
implements GHNMBean {
    protected AtomicInteger seqNum = new AtomicInteger(0);

    @Override
    public String getUptime() {
        return GHNContext.getContext().getUptime();
    }

    @Override
    public void restart() throws Exception {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                GHNContext.getContext().restart(new String[0]);
            }
        }.start();
    }

    @Override
    public String addScope(String s) throws Exception {
        Set<GCUBEScope> scopes = GHNContext.getContext().addScope(GCUBEScope.getScope(s));
        this.notifyAddedScope(GCUBEScope.getScope(s));
        return (scopes.size() > 0 ? scopes.iterator().next() : "no scope") + " was added to the GHN";
    }

    @Override
    public String removeScope(String s) throws Exception {
        GCUBEScope scope = GCUBEScope.getScope(s);
        Set<GCUBEScope> scopes = GHNContext.getContext().removeScope(scope);
        return (scopes.size() > 0 ? scopes.iterator().next() : "no scope") + " was removed from the Running Instance";
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"org.gcube.ghn.scope.add"};
        String name = GHNNotification.class.getName();
        String description = "GHN Scope added";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, name, description);
        return new MBeanNotificationInfo[]{info};
    }

    public void notifyAddedScope(GCUBEScope scope) {
        GHNNotification event = new GHNNotification("org.gcube.ghn.scope.add", (Object)this, "Scope added: " + scope.toString(), (long)this.seqNum.getAndAdd(1));
        this.sendNotification(event);
    }
}

