/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.util;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import org.reflections.Reflections;
import org.reflections.vfs.Vfs;
import sun.net.www.ParseUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClasspathHelper {
    public static ClassLoader[] defaultClassLoaders = new ClassLoader[]{ClasspathHelper.getContextClassLoader(), ClasspathHelper.getStaticClassLoader()};

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getStaticClassLoader() {
        return Reflections.class.getClassLoader();
    }

    public static ClassLoader[] classLoaders(ClassLoader ... classLoaders) {
        return classLoaders != null && classLoaders.length != 0 ? classLoaders : defaultClassLoaders;
    }

    public static Set<URL> forPackage(String name, ClassLoader ... classLoaders) {
        HashSet result = Sets.newHashSet();
        ClassLoader[] loaders = ClasspathHelper.classLoaders(classLoaders);
        String resourceName = name.replace(".", "/");
        String encodedResourceName = ParseUtil.encodePath(resourceName);
        for (ClassLoader classLoader : loaders) {
            try {
                Enumeration<URL> urls = classLoader.getResources(resourceName);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    int index = url.toExternalForm().lastIndexOf(encodedResourceName);
                    if (index == -1) continue;
                    result.add(new URL(url.toExternalForm().substring(0, index)));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static URL forClass(Class<?> aClass, ClassLoader ... classLoaders) {
        ClassLoader[] loaders = ClasspathHelper.classLoaders(classLoaders);
        String resourceName = aClass.getName().replace(".", "/") + ".class";
        for (ClassLoader classLoader : loaders) {
            try {
                URL url = classLoader.getResource(resourceName);
                if (url == null) continue;
                String normalizedUrl = url.toExternalForm().substring(0, url.toExternalForm().lastIndexOf(aClass.getPackage().getName().replace(".", "/")));
                return new URL(normalizedUrl);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Set<URL> forClassLoader(ClassLoader ... classLoaders) {
        ClassLoader[] loaders;
        HashSet result = Sets.newHashSet();
        ClassLoader[] arr$ = loaders = ClasspathHelper.classLoaders(classLoaders);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            for (ClassLoader classLoader = arr$[i$]; classLoader != null; classLoader = classLoader.getParent()) {
                Object[] urls;
                if (!(classLoader instanceof URLClassLoader) || (urls = ((URLClassLoader)classLoader).getURLs()) == null) continue;
                result.addAll(Sets.newHashSet((Object[])urls));
            }
        }
        return result;
    }

    public static Set<URL> forJavaClassPath() {
        HashSet urls = Sets.newHashSet();
        String javaClassPath = System.getProperty("java.class.path");
        if (javaClassPath != null) {
            for (String path : javaClassPath.split(File.pathSeparator)) {
                try {
                    urls.add(new File(path).toURI().toURL());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return urls;
    }

    public static Set<URL> forWebInfLib(ServletContext servletContext) {
        HashSet urls = Sets.newHashSet();
        for (Object urlString : servletContext.getResourcePaths("/WEB-INF/lib")) {
            try {
                urls.add(servletContext.getResource((String)urlString));
            }
            catch (MalformedURLException e) {}
        }
        return urls;
    }

    public static URL forWebInfClasses(ServletContext servletContext) {
        try {
            String path = servletContext.getRealPath("/WEB-INF/classes");
            File file = new File(path);
            if (file.exists()) {
                return file.toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public static Set<URL> forManifest() {
        return ClasspathHelper.forManifest(ClasspathHelper.forClassLoader(new ClassLoader[0]));
    }

    public static Set<URL> forManifest(URL url) {
        HashSet result = Sets.newHashSet();
        result.add(url);
        try {
            String classPath;
            Manifest manifest;
            String part = Vfs.normalizePath(url);
            File jarFile = new File(part);
            JarFile myJar = new JarFile(part);
            URL validUrl = ClasspathHelper.tryToGetValidUrl(jarFile.getPath(), new File(part).getParent(), part);
            if (validUrl != null) {
                result.add(validUrl);
            }
            if ((manifest = myJar.getManifest()) != null && (classPath = manifest.getMainAttributes().getValue(new Attributes.Name("Class-Path"))) != null) {
                for (String jar : classPath.split(" ")) {
                    validUrl = ClasspathHelper.tryToGetValidUrl(jarFile.getPath(), new File(part).getParent(), jar);
                    if (validUrl == null) continue;
                    result.add(validUrl);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static Set<URL> forManifest(Iterable<URL> urls) {
        HashSet result = Sets.newHashSet();
        for (URL url : urls) {
            result.addAll(ClasspathHelper.forManifest(url));
        }
        return result;
    }

    static URL tryToGetValidUrl(String workingDir, String path, String filename) {
        try {
            if (new File(filename).exists()) {
                return new File(filename).toURI().toURL();
            }
            if (new File(path + File.separator + filename).exists()) {
                return new File(path + File.separator + filename).toURI().toURL();
            }
            if (new File(workingDir + File.separator + filename).exists()) {
                return new File(workingDir + File.separator + filename).toURI().toURL();
            }
            if (new File(new URL(filename).getFile()).exists()) {
                return new File(new URL(filename).getFile()).toURI().toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }
}

