/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.common;

import com.terradue.wps_hadoop.streaming.HadoopStreaming;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.log4j.Logger;
import org.n52.wps.io.data.IData;
import org.n52.wps.server.AbstractAlgorithm;

public abstract class StreamingAbstractAlgorithm<OK, OV>
extends AbstractAlgorithm {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    protected Configuration hadoopConfig = new Configuration();
    protected FileSystem hdfs = null;
    protected String hdfsPrefix;

    protected abstract String[] getArguments(Map<String, List<IData>> var1);

    public final Map<String, IData> run(Map<String, List<IData>> inputData) {
        this.prepareToRun(inputData);
        this.logger.info((Object)"Calling Streaming utility...");
        try {
            int code = HadoopStreaming.doRun(this.hadoopConfig, this.getArguments(inputData));
            if (code > 0) {
                throw new RuntimeException(HadoopStreaming.getErrorCodes(code));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        this.logger.info((Object)"Building results");
        return this.buildResults(inputData);
    }

    protected void prepareToRun(Map<String, List<IData>> inputData) {
    }

    protected abstract Map<String, IData> buildResults(Map<String, List<IData>> var1);
}

