/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.common;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.Reducer;
import org.apache.log4j.Logger;
import org.n52.wps.io.data.IData;
import org.n52.wps.server.AbstractAlgorithm;

public abstract class HadoopAbstractAlgorithm<OK, OV>
extends AbstractAlgorithm {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    protected Configuration hadoopConfig = new Configuration();
    protected FileSystem hdfs = null;
    protected String hdfsPrefix;
    protected final String hdfsPostfix = "/user/rcirillo";
    public final String wpsLocation = String.valueOf(System.getProperty("catalina.base")) + "/webapps/wps/";
    protected double startElapsedTime;
    protected double startExecutionTime;
    protected double endTime;

    protected abstract Class<? extends Mapper<?, ?, OK, OV>> getMapper();

    protected Class<? extends Reducer<LongWritable, OV, ?, ?>> getReducer() {
        return null;
    }

    protected abstract JobConf getJobConf();

    protected abstract String getJobName();

    protected abstract Path[] getInputPaths(Map<String, List<IData>> var1);

    protected abstract String getOutputPath();

    public final Map<String, IData> run(Map<String, List<IData>> inputData) {
        this.prepareToRun(inputData);
        this.logger.info((Object)"Getting JobConf");
        JobConf conf = new JobConf(this.hadoopConfig);
        this.logger.info((Object)("Setting JobName = " + this.getJobName()));
        conf.setJobName(this.getJobName());
        String path = this.getJarPath();
        this.logger.info((Object)("getting jar: " + path));
        conf.setJar(path);
        this.logger.info((Object)("getting Mapper Class = " + this.getMapper()));
        conf.setMapperClass(this.getMapper());
        if (this.getReducer() != null) {
            this.logger.info((Object)("getting Reducer Class = " + this.getReducer()));
            conf.setReducerClass(this.getReducer());
        }
        Properties hadoopProp = new Properties();
        try {
            hadoopProp.load(new FileInputStream(String.valueOf(this.wpsLocation) + "config/hadoop_settings.properties"));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Set<Object> s = hadoopProp.keySet();
        if (s == null) {
            this.logger.error((Object)"set of property is empty ");
        } else if (!s.isEmpty()) {
            this.logger.info((Object)"the set of properties is full");
        } else {
            this.logger.info((Object)"the set of properties is empty!!!");
        }
        for (Object p : s) {
            this.logger.info((Object)"check property ");
            String name = p.toString();
            this.logger.info((Object)("property name: " + name));
            String value = hadoopProp.getProperty(name);
            this.logger.info((Object)("set property: " + name + " " + value));
            conf.set(name, value);
        }
        this.logger.info((Object)("check Mapper: " + conf.getMapperClass()));
        this.logger.info((Object)("check Reducer: " + conf.getReducerClass()));
        conf.setMapOutputKeyClass(LongWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.reloadConfiguration();
        this.logger.info((Object)("Setting Input Paths:  " + this.getInputPaths(inputData)[0]));
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{this.getInputPaths(inputData)[0]});
        this.logger.info((Object)("getting OutputPath " + this.getOutputPath()));
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(this.getOutputPath()));
        try {
            this.logger.info((Object)"Running Job...");
            this.startExecutionTime = System.currentTimeMillis();
            JobClient.runJob((JobConf)conf);
            this.endTime = System.currentTimeMillis();
            this.logger.info((Object)("Execution Time : " + (this.endTime - this.startExecutionTime) / 1000.0 + " secs"));
        }
        catch (IOException e) {
            throw new RuntimeException("Error accessing to Input/Output Path", e);
        }
        this.logger.info((Object)"Building results");
        return this.buildResults();
    }

    protected abstract String getJarPath();

    protected void prepareToRun(Map<String, List<IData>> inputData) {
    }

    protected abstract Map<String, IData> buildResults();
}

