/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.filesmanagement.queue;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.datatransformation.harvester.core.MessageForEveryDataProvider;
import org.gcube.datatransformation.harvester.filesmanagement.manager.FilesManagerRead;
import org.gcube.datatransformation.harvester.filesmanagement.queue.QueuedRequests;
import org.gcube.datatransformation.harvester.utils.GetProperties;

public class ReadUrls
implements FilesManagerRead {
    private static final Logger logger = Logger.getLogger(ReadUrls.class);

    public void readFromFile(boolean initialization) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            File file = new File(GetProperties.getPropertiesInstance().getQueuedFile());
            if (file != null && file.canRead() && file.length() != 0L) {
                List<Object> messagesForEveryDataProviders = Arrays.asList((Object[])objectMapper.readValue(file, MessageForEveryDataProvider[].class));
                for (MessageForEveryDataProvider messageForEveryDataProvider : messagesForEveryDataProviders) {
                    QueuedRequests.getQueuedRequestsInstance().setInRequestsMapping(messageForEveryDataProvider.getInfoForHarvesting().getUrl(), messageForEveryDataProvider);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.info((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.info((Object)e.getMessage());
            e.printStackTrace();
        }
    }
}

