/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.harvestedmanagement.core;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Set;
import org.apache.log4j.Logger;
import org.gcube.datatransformation.harvester.core.MessageForEveryDataProvider;
import org.gcube.datatransformation.harvester.core.db.HarvestedInfoObject;
import org.gcube.datatransformation.harvester.core.db.ManagerOfHarvested;
import org.gcube.datatransformation.harvester.core.db.RetrievedNodes;
import org.gcube.datatransformation.harvester.elasticsearch.ElasticSearchManager;
import org.gcube.datatransformation.harvester.mongodb.harvestedmanagement.StoreToMongoDB;
import org.gcube.datatransformation.harvester.postgresql.harvestedmanagement.StoreToPostgreSQL;
import org.gcube.datatransformation.harvester.utils.GetProperties;

public class SelectedDatabase {
    private static final Logger logger = Logger.getLogger(SelectedDatabase.class);
    private static SelectedDatabase selectedDB;
    private ManagerOfHarvested selectedDbImplementation = null;

    protected SelectedDatabase() {
        String className = GetProperties.getPropertiesInstance().getClassNameForDB();
        if (className.equals("StoreToPostgreSQL")) {
            this.selectedDbImplementation = StoreToPostgreSQL.getStoreToPostgreSQLInstance((String)GetProperties.getPropertiesInstance().getJdbcDriver(), (String)GetProperties.getPropertiesInstance().getJdbcUrl(), (String)GetProperties.getPropertiesInstance().getDbusername(), (String)GetProperties.getPropertiesInstance().getDbpassword());
        } else if (className.equals("StoreToMongoDB")) {
            this.selectedDbImplementation = StoreToMongoDB.getStoreToMongoDBInstance((String)GetProperties.getPropertiesInstance().getMongodb());
        } else if (className.equals("ElasticSearchManager")) {
            this.selectedDbImplementation = ElasticSearchManager.getElasticSearchManager((String)GetProperties.getPropertiesInstance().getIndexScope());
        }
    }

    public static SelectedDatabase getSelectedDatabaseInstance() {
        if (selectedDB == null) {
            selectedDB = new SelectedDatabase();
        }
        return selectedDB;
    }

    public void storeToDB(MessageForEveryDataProvider msg, RetrievedNodes retrievedNodes, Boolean firstTimeToStore) {
        try {
            HarvestedInfoObject obj = new HarvestedInfoObject();
            obj.setRetrievedNodes(retrievedNodes);
            obj.setCollectionID(msg.getCollectionID());
            obj.setScope(msg.getScope());
            obj.setUri(msg.getInfoForHarvesting().getUrl());
            obj.setVerb("ListRecords");
            obj.setMetadataPrefix(msg.getInfoForHarvesting().getListRecords().getMetadataPrefix());
            obj.setFirstTimeToStore(firstTimeToStore);
            this.selectedDbImplementation.storeHarvested(obj);
        }
        catch (IOException | SQLException e) {
            logger.info((Object)e.getMessage());
        }
    }

    public void removeFromDB(Set<String> collectionIdsToDelete) {
        String className = GetProperties.getPropertiesInstance().getClassNameForDB();
        if (className.equals("ElasticSearchManager")) {
            return;
        }
        try {
            this.selectedDbImplementation.deleteHarvested(collectionIdsToDelete);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
        }
    }
}

