(function() {
'use strict';

var pageState = {};


var renderURL = "";
var resourceURL = "";
var contextPath = "";



function init(renderURL, resourceURL) {

	renderURL = renderURL;
	resourceURL = resourceURL;
	
	initNavBar(resourceURL);
	
	$('#setUri').prop('required',true);
	$.ajax({
		url: createLink(resourceURL, 'registerurl/getUris'),
		type: 'get',
		dataType: 'json',
		contentType: 'application/json',
		success: function(uris) {
			for (var i=0; i<uris.length; i++) {
				$("#listOfUris").append("<li><a> " +  uris[i] +"</a></li>");
				$.data($('#dropdownForUri').closest('.btn-group').find('ul li:last-child')[0], 'categoryValue', uris[i]);
			}
			
			if(uris.length === 0) {
				$('#dropdownForUri').dropdownDisplayMode = $('#dropdownForUri').css('display');
				$('#dropdownForUri').hide();
			} else $('#dropdownForUri').css('display', $('#dropdownForUri').dropdownDisplayMode);
			
			$('#dropdownForUri').closest('.btn-group').find('ul li').on('click', function(e) {
				var li = $(e.target).is('li') ? e.target : $(e.target).closest('li')[0];
		    	var catValue = $.data(li, 'categoryValue');
		    	$('#dropdownForUri').find('div.categoryName').html($(li).find('a').text());
		    	$('#dropdownForUri').find('.categoryAdd div.caret').removeClass('empty');
		    	$('#dropdownForUri').currentCategory = catValue;
		    	$('#dropdownForUri').addingTwoPhase = true;
		    	
		    	pageState.catValue = catValue;
		    	
		    	
	    	});
			
			$("#dropdownForUri li:first-child").click();
		},
		error: function(jqXHR, textStatus, errorThrown) {
    		$('html').removeClass('loading');
   			alert("The following error occured: " + textStatus, errorThrown);
   		}
	});
	$('.dropdown-toggle').dropdown();
	
	$('#harvestSub').click(function(e) {
		e.preventDefault();
		$.ajax({
			url: createLink(resourceURL, '../ui/harvest?registeredUri='+pageState.catValue),
			type: 'get',
			contentType: 'application/json',
			success: function(response) {
				alert(response);
			},
			error: function(jqXHR, textStatus, errorThrown) {
	    		$('html').removeClass('loading');
	   			alert("The following error occured: " + textStatus, errorThrown);
	   		}
		});
	});
	
	$('#harvestAllSub').click(function(e) {
		e.preventDefault();
		$.ajax({
			url: createLink(resourceURL, '../ui/harvest'),
			type: 'get',
			contentType: 'application/json',
			success: function(response) {
				alert(response);
			},
			error: function(jqXHR, textStatus, errorThrown) {
	    		$('html').removeClass('loading');
	   			alert("The following error occured: " + textStatus, errorThrown);
	   		}
		});
	});
	
}
		
function postDataToServer(json, postUrl, callback) {
	$.ajax({
		url: postUrl,
		type: 'post',
		cache: false,
	    contentType: "application/json",
	    dataType: "json",
		data: JSON.stringify(json),
		success: function(response) {
			if(response.status != 200) {
				alert(response.message);
				return;
			}
			if(callback) callback();
		},
		error : function(jqXHR, textStatus, errorThrown) {
			alert("An error occured");
	     }
	});	
}

function createLink(url, resource, param) {
	var link;
	if (param === undefined) {
		link = url.replace('%7Burl%7D', resource).replace('%7Bparams%7D', '');
		if (link.charAt(link.length - 1) == "?")
			link = link.slice(0, -1);
			
	} else
		link = url.replace('%7Burl%7D', resource).replace('%7Bparams%7D', param);
	
	return link;
}

window.Harvester = {};
window.Harvester.init = init;

}());