(function() {
'use strict';

var pageState = {};


var renderURL = "";
var resourceURL = "";
var contextPath = "";



function init(renderURL, resourceURL) {

	renderURL = renderURL;
	resourceURL = resourceURL;
	initNavBar(resourceURL);
	
	pageState.renderURL = renderURL;
	pageState.resourceURL = resourceURL;
	
	
	$.ajax({
		url: createLink(resourceURL, 'registerurl/getUris'),
		type: 'get',
		dataType: 'json',
		contentType: 'application/json',
		success: function(uris) {
			
			for (var i=0; i<uris.length; i++) {
				$("#listOfUrisToDelete").append("<li><a> " +  uris[i] +"</a></li>");
				$.data($('#dropdownForUrisToDelete').closest('.btn-group').find('ul li:last-child')[0], 'categoryValue', uris[i]);
			}
			
			if(uris.length === 0) {
				$('#dropdownForUrisToDelete').dropdownDisplayMode = $('#dropdownForUrisToDelete').css('display');
				$('#dropdownForUrisToDelete').hide();
			} else 
				$('#dropdownForUrisToDelete').css('display', $('#dropdownForUrisToDelete').dropdownDisplayMode);
			
			$('#dropdownForUrisToDelete').closest('.btn-group').find('ul li').on('click', function(e) {
				var li = $(e.target).is('li') ? e.target : $(e.target).closest('li')[0];
		    	var catValue = $.data(li, 'categoryValue');
		    	$('#dropdownForUrisToDelete').find('div.categoryName').html($(li).find('a').text());
		    	$('#dropdownForUrisToDelete').find('.categoryAdd div.caret').removeClass('empty');
		    	$('#dropdownForUrisToDelete').currentCategory = catValue;
		    	$('#dropdownForUrisToDelete').addingTwoPhase = true;
		    
		    	pageState.catValue = catValue;
	    	});
			
			$("#dropdownForUrisToDelete li:first-child").click();
		},
		error: function(jqXHR, textStatus, errorThrown) {
    		$('html').removeClass('loading');
   			alert("The following error occured: " + textStatus, errorThrown);
   		}
	});
	$('.dropdown-toggle').dropdown();
	
	$('#deleteRegisteredUrisSub').click(function(e) {
		e.preventDefault();
	
		postDataToServer(pageState.catValue, 'registerurl/deleteUri', function() {
			$('#dropdownForUrisToDelete ul').empty();
			
			
			init(pageState.renderURL, pageState.resourceURL);
		});
	});
	
	
	
}
		




function postDataToServer(json, postUrl, callback) {
	$.ajax({
		url: postUrl,
		type: 'post',
		cache: false,
	    contentType: "application/json",
	    dataType: "json",
		data: json,
		success: function(response) {
			if(!response) {
				alert('Something was wrong');
				return;
			}
			if(callback) callback();
		},
		error : function(jqXHR, textStatus, errorThrown) {
			alert("An error occured");
	     }
	});	
}

function createLink(url, resource, param) {
	var link;
	if (param === undefined) {
		link = url.replace('%7Burl%7D', resource).replace('%7Bparams%7D', '');
		if (link.charAt(link.length - 1) == "?")
			link = link.slice(0, -1);
			
	} else
		link = url.replace('%7Burl%7D', resource).replace('%7Bparams%7D', param);
	
	return link;
}

window.Harvester = {};
window.Harvester.init = init;

}());