/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.filesmanagement.times;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gcube.datatransformation.harvester.filesmanagement.manager.FilesManagerRead;
import org.gcube.datatransformation.harvester.filesmanagement.manager.RWActions;
import org.gcube.datatransformation.harvester.filesmanagement.times.CustomTimes;
import org.gcube.datatransformation.harvester.filesmanagement.times.DefaultTime;
import org.gcube.datatransformation.harvester.filesmanagement.times.ReadUrls;

public class TimesReader {
    private static TimesReader timesReader = null;
    private DefaultTime configuredTime = null;
    private Map<String, Map<String, CustomTimes>> timesMapping = Collections.synchronizedMap(new HashMap());

    public static synchronized TimesReader getTimesReaderInstance() {
        if (timesReader == null) {
            timesReader = new TimesReader();
            RWActions.readFromFile((FilesManagerRead)new ReadUrls(), (boolean)false);
        }
        return timesReader;
    }

    protected TimesReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setConfiguredTime(DefaultTime time) {
        Map map = this.timesMapping;
        synchronized (map) {
            this.configuredTime = time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DefaultTime getConfiguredTime() {
        Map map = this.timesMapping;
        synchronized (map) {
            return this.configuredTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addToTimesMapping(String scope, CustomTimes value) {
        Map map = this.timesMapping;
        synchronized (map) {
            HashMap<String, CustomTimes> times = (HashMap<String, CustomTimes>)this.timesMapping.get(scope);
            times = times == null ? (times = new HashMap<String, CustomTimes>()) : times;
            times.put(value.getUrl(), value);
            this.timesMapping.put(scope, times);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeFromTimesMapping(String scope, String url) {
        Map map = this.timesMapping;
        synchronized (map) {
            Map times = (Map)this.timesMapping.get(scope);
            if (times != null && times.remove(url) != null) {
                this.timesMapping.put(scope, times);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CustomTimes getFromTimesMapping(String scope, String url) {
        Map map = this.timesMapping;
        synchronized (map) {
            Map cts = (Map)this.timesMapping.get(scope);
            return cts != null ? (CustomTimes)cts.get(url) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<String, CustomTimes> getTimesMappingPerScope(String scope) {
        Map map = this.timesMapping;
        synchronized (map) {
            return (Map)this.timesMapping.get(scope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<String, Map<String, CustomTimes>> getTimesMapping() {
        Map map = this.timesMapping;
        synchronized (map) {
            return this.timesMapping;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTimesMapping(Map<String, Map<String, CustomTimes>> timesMapping) {
        Map map = this.timesMapping;
        synchronized (map) {
            this.timesMapping = timesMapping;
        }
    }
}

