/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.dataservice.servicecontrol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.gcube.datatransformation.harvester.core.MessageForEveryDataProvider;
import org.gcube.datatransformation.harvester.core.requestedtypes.verbs.Verbs;
import org.gcube.datatransformation.harvester.dataservice.manager.HarvestUrlManager;
import org.gcube.datatransformation.harvester.dataservice.manager.ReposInfoMessenger;
import org.gcube.datatransformation.harvester.dataservice.manager.messenger.EditInfoMessenger;
import org.gcube.datatransformation.harvester.dataservice.manager.messenger.FetchAllInfoMessenger;
import org.gcube.datatransformation.harvester.dataservice.manager.messenger.MinorMessenger;
import org.gcube.datatransformation.harvester.dataservice.manager.messenger.NewServiceMessenger;
import org.gcube.datatransformation.harvester.filesmanagement.archive.RegisteredRequests;
import org.gcube.datatransformation.harvester.filesmanagement.queue.QueuedRequests;
import org.gcube.datatransformation.harvester.requestmanagement.RequestManager;
import org.gcube.datatransformation.harvester.responsesofservice.ServiceResponse;
import org.gcube.datatransformation.harvester.utils.GetProperties;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/harvesturl"})
public class HarvestUrlController {
    @RequestMapping(value={"/harvester"}, method={RequestMethod.GET})
    public String harvester(Model model) {
        return "harvester";
    }

    @RequestMapping(value={"/registerurl/getVerbs"}, method={RequestMethod.GET}, consumes={"application/json"})
    @ResponseBody
    public List<Verbs> fetchVerbs(HttpServletRequest request) throws Exception {
        return HarvestUrlManager.fetchVerbs();
    }

    @RequestMapping(value={"/registerurl/getUrlForService"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> fetchUrlForService(HttpServletRequest request) {
        ArrayList<String> newL = new ArrayList<String>();
        newL.add(GetProperties.getPropertiesInstance().getNewServiceUrlParameters());
        return newL;
    }

    @RequestMapping(value={"/registerurl/getUrlForDeleteService"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> fetchUrlForDeleteService(HttpServletRequest request) {
        ArrayList<String> newL = new ArrayList<String>();
        newL.add(GetProperties.getPropertiesInstance().getDeleteServiceUrlParameters());
        return newL;
    }

    @RequestMapping(value={"/registerurl/getInfoForRegisteredUris"}, method={RequestMethod.GET})
    @ResponseBody
    public ServiceResponse fetchInfoForRegisteredUris(HttpServletRequest request) throws Exception {
        String scope = request.getHeader("scope");
        if (scope == null || scope.isEmpty()) {
            return new ServiceResponse(false, null, "Empty scope");
        }
        FetchAllInfoMessenger messenger = HarvestUrlManager.fetchInfoForRegisteredUris((String)scope);
        return messenger.getInfo().isEmpty() ? new ServiceResponse(false, null, "No data sources for this scope") : new ServiceResponse(true, (Object)messenger, "Info returned");
    }

    @RequestMapping(value={"/registerurl/getUris"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> fetchUris(HttpServletRequest request) throws Exception {
        String scope = request.getHeader("scope");
        if (scope == null || scope.isEmpty()) {
            return new ArrayList<String>();
        }
        return HarvestUrlManager.fetchUris((String)scope);
    }

    @RequestMapping(value={"/registerurl/deleteUri"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public ServiceResponse deleteRegisteredUri(@RequestBody String uri, HttpServletRequest request) throws Exception {
        String scope = request.getHeader("scope");
        if (scope == null || scope.isEmpty()) {
            return new ServiceResponse(false, null, "Empty scope");
        }
        if (HarvestUrlManager.deleteUri((String)uri, (String)scope)) {
            return new ServiceResponse(true, null, "uri deleted");
        }
        return new ServiceResponse(false, null, "uri not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/registerurl/registerUri"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public ServiceResponse registereUri(@RequestBody NewServiceMessenger nsm, HttpServletRequest request) throws Exception {
        String scope = request.getHeader("scope");
        if (scope == null || scope.isEmpty()) {
            return new ServiceResponse(false, null, "Empty scope");
        }
        if (nsm.getNewUri() == null || nsm.getNewUri().trim().isEmpty()) {
            return new ServiceResponse(false, null, "URI was not specified");
        }
        String regex = "^http(\\w)*://";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(nsm.getNewUri().trim());
        if (!matcher.find()) {
            return new ServiceResponse(false, null, "Uri is not absolute");
        }
        if (!nsm.getNewIntervalTime().trim().isEmpty()) {
            try {
                if (!nsm.getDefaultTime().booleanValue()) {
                    Integer.parseInt(nsm.getNewIntervalTime());
                    if (!(nsm.getNewTimeUnit().toUpperCase().equals("DAYS") || nsm.getNewTimeUnit().toUpperCase().equals("HOURS") || nsm.getNewTimeUnit().toUpperCase().equals("MINUTES"))) {
                        return new ServiceResponse(false, null, "TimeUnit has not an appropriate format");
                    }
                }
            }
            catch (NumberFormatException e) {
                return new ServiceResponse(false, null, "TimeUnit has not an appropriate format");
            }
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("harvest-new-service", "true");
        parameters.put("newUri", nsm.getNewUri().trim());
        parameters.put("schema", nsm.getSchema().trim());
        parameters.put("defaultTime", nsm.getDefaultTime().toString());
        parameters.put("newIntervalTime", nsm.getNewIntervalTime().trim());
        parameters.put("newTimeUnit", nsm.getNewTimeUnit().trim());
        List registered = null;
        registered = RegisteredRequests.getRegisteredRequestsInstance().getFromRegisteredRequestsMapping(nsm.getNewUri().trim());
        if (registered != null && !registered.isEmpty()) {
            RegisteredRequests.getRegisteredRequestsInstance().setToDeleteFalse(nsm.getNewUri().trim());
            if (RegisteredRequests.getRegisteredRequestsInstance().checkExistence(nsm.getNewUri().trim(), nsm.getSchema().trim(), scope)) {
                return new ServiceResponse(true, null, "URI is already registered");
            }
        }
        Class<QueuedRequests> clazz = QueuedRequests.class;
        synchronized (QueuedRequests.class) {
            List queued = null;
            queued = QueuedRequests.getQueuedRequestsInstance().getFromQueuedRequestsMapping(nsm.getNewUri().trim());
            if (queued != null && !queued.isEmpty() && !((MessageForEveryDataProvider)queued.get(0)).getToDelete().booleanValue()) {
                for (MessageForEveryDataProvider mm : queued) {
                    if (!(nsm.getSchema().trim().equals("all") && mm.getSchemaSupportedForUrl().equals("all") && mm.getScope().equals(scope) || nsm.getSchema().trim().equals("dc") && mm.getSchemaSupportedForUrl().equals("dc") && mm.getScope().equals(scope)) && (!nsm.getSchema().trim().equals("dc") || !mm.getSchemaSupportedForUrl().equals("all") || !mm.getScope().equals(scope))) continue;
                    // ** MonitorExit[var9_10] (shouldn't be in output)
                    return new ServiceResponse(true, null, "URI is already registered");
                }
            }
            // ** MonitorExit[var9_10] (shouldn't be in output)
            try {
                RequestManager.proceedToRegister(parameters, (String)scope);
            }
            catch (Exception e) {
                return new ServiceResponse(false, null, "URI was not registered -- uri was not specified correctly");
            }
            return new ServiceResponse(true, null, "URI was registered");
        }
    }

    @RequestMapping(value={"/registerurl/reharvestUri"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public Boolean reharvestRegisteredUri(@RequestBody MinorMessenger mm, HttpServletRequest request) throws Exception {
        String scope = request.getHeader("scope");
        if (scope == null || scope.isEmpty()) {
            return false;
        }
        return HarvestUrlManager.reharvestUri((String)mm.getUrl(), (String)mm.getMetadataPrefix(), (String)scope);
    }

    @RequestMapping(value={"/registerurl/editRegUri"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public Boolean editRegisteredUri(@RequestBody EditInfoMessenger editInfoM, HttpServletRequest request) throws Exception {
        int newtime;
        String scope = request.getHeader("scope");
        if (scope == null || scope.isEmpty()) {
            return false;
        }
        if (editInfoM.getTime() == null && editInfoM.getTimeUnit() == null || editInfoM.getDefaultTime() == null && editInfoM.getDefaultTimeUnit() == null) {
            return false;
        }
        try {
            newtime = Integer.parseInt(editInfoM.getTime());
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (editInfoM.getUrl() == null || editInfoM.getUrl().isEmpty()) {
            return false;
        }
        return HarvestUrlManager.editRegisteredUri((String)editInfoM.getUrl().trim(), (Integer)newtime, (String)editInfoM.getTimeUnit(), (String)editInfoM.getDefaultTime(), (String)editInfoM.getDefaultTimeUnit(), (String)scope);
    }

    @RequestMapping(value={"/registerurl/getInfoForEachRepo"}, method={RequestMethod.GET})
    @ResponseBody
    public ReposInfoMessenger fetchInfoForEachRepo(HttpServletRequest request) throws Exception {
        String scope = request.getHeader("scope");
        if (scope == null || scope.isEmpty()) {
            return new ReposInfoMessenger();
        }
        return HarvestUrlManager.fetchInfoForEachRepo((String)scope);
    }
}

