/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.elasticsearch.loaders;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class Transformers {
    private static final String JSON_TRANSFORMERS_FOLDER = "json_transformers/";
    private static Map<String, String> jsonTransformerStrings;
    private static boolean isInit;
    private static final Logger logger;

    public static synchronized void init() {
        jsonTransformerStrings = new ConcurrentHashMap<String, String>();
        URL transformerUrl = Thread.currentThread().getContextClassLoader().getResource(JSON_TRANSFORMERS_FOLDER);
        URI transformerFilePath = null;
        if (transformerUrl != null) {
            try {
                transformerFilePath = transformerUrl.toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (transformerFilePath != null) {
            File dir = new File(transformerFilePath);
            if (dir.exists() && dir.isDirectory()) {
                for (File file : dir.listFiles()) {
                    try {
                        jsonTransformerStrings.put(file.getName(), Transformers.readFile(file.toURI(), Charset.defaultCharset()));
                    }
                    catch (IOException e) {
                        logger.info((Object)"Could not load a json transformer");
                    }
                }
            }
            logger.debug((Object)("Found the following jsonTrnasformers in the classpath: " + jsonTransformerStrings));
        } else {
            logger.error((Object)("Could not load the folder containing the JSON transformers... No " + transformerUrl + " folder found within the classpath."));
        }
    }

    public static Map<String, String> getAllTransformers() {
        if (!isInit) {
            Transformers.init();
        }
        return jsonTransformerStrings;
    }

    private static synchronized String readFile(URI path, Charset encoding) throws IOException {
        return new String(Files.readAllBytes(Paths.get(path)), encoding);
    }

    static {
        isInit = false;
        logger = Logger.getLogger(Transformers.class);
    }
}

