package org.gcube.datatransformation.client.library.proxies;

import java.util.Map;
import java.util.Map.Entry;

import org.gcube.datatransformation.client.library.exceptions.DTSException;

public interface DTSCLProxyI {
	public String transformData(final String inputType, final String inputValue, final Map<String, String> inputParams, final String outputType,
			final String outputValue, final Map<String, String> outputParams, final String mimeType, final Map<String, String> contentTypeParams,
			boolean createReport) throws DTSException;

	public String transformDataWithTransformationUnit(final String transformationProgramID, final String transformationUnitID,
			final Map<Entry<String, String>, Map<String, String>> inputs, final String outputType, final String outputValue,
			final Map<String, String> outputParams, final String mimeType, final Map<String, String> contentTypeParams,
			final Map<String, String> tProgramUnboundParameters, boolean filterSources, boolean createReport);

	public String transformDataWithTransformationProgram(final String transformationProgramID, final String inputType, final String inputValue,
			final Map<String, String> inputParams, final String outputType, final String outputValue, final Map<String, String> outputParams,
			final String mimeType, final Map<String, String> contentTypeParams, final Map<String, String> tProgramUnboundParameters, boolean createReport);

	public Map<String, String> findApplicableTransformationUnits(final String sourceMimeType, final Map<String, String> sourceContentTypeParams,
			final String targetMimeType, final Map<String, String> targetContentTypeParams,
			final boolean createAndPublishCompositeTP);
	
	public String queryTransformationPrograms(String query);
}
