/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasource.predefined;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.FieldNaming;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasource.DataSource;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.common.clients.queries.Query;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.streams.Stream;
import org.gcube.data.tml.proxies.TReader;
import org.gcube.data.tml.proxies.TServiceFactory;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.XMLBindings;
import org.gcube.data.trees.patterns.EdgePattern;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.patterns.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TMDataSource
extends DataSource {
    private static final String GCUBEACTIONSCOPE = "GCubeActionScope";
    private String scope;
    private static Logger log = LoggerFactory.getLogger((String)TMDataSource.class.getName());
    private String collectionId;
    private TReader tReader;

    public TMDataSource(String input, Map<String, String> inputParameters) throws Exception {
        super(input, inputParameters);
        if (inputParameters != null) {
            this.filterMask = inputParameters.get("filterMask");
            this.scope = inputParameters.get(GCUBEACTIONSCOPE);
        }
        if (this.scope == null) {
            throw new Exception("Scope not set");
        }
        this.fieldDefs = TMDataSource.initializeSchema(this.filterMask);
        this.writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), new RecordDefinition[]{new GenericRecordDefinition(this.fieldDefs)}, RecordWriter.DefaultBufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
        this.collectionId = this.input;
        StatefulQuery query = TServiceFactory.readSource().withId(this.collectionId).build();
        this.tReader = (TReader)TServiceFactory.reader().matching((Query)query).build();
        if (this.tReader == null) {
            log.error("Could not retrieve collection " + this.collectionId + " for specified scope " + this.scope);
            throw new Exception("Could not retrieve collection " + this.collectionId + " for specified scope " + this.scope);
        }
        log.info("Ininializing tm data source for collection: " + this.collectionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long start;
        long firstInputStop = start = Calendar.getInstance().getTimeInMillis();
        long firstOutputStop = start;
        int rc = 0;
        try {
            ScopeProvider.instance.set(this.scope);
            Stream treesReader = this.tReader.get((Pattern)Patterns.tree((EdgePattern[])new EdgePattern[0]));
            while (treesReader.hasNext()) {
                Tree t = (Tree)treesReader.next();
                if (rc == 0) {
                    firstInputStop = Calendar.getInstance().getTimeInMillis();
                }
                ArrayList<StringField> fieldList = new ArrayList<StringField>();
                block18: for (FieldDefinition field : this.fieldDefs) {
                    switch (FieldNaming.TMFieldName.valueOf(field.getName())) {
                        case id: {
                            fieldList.add(new StringField(t.id() != null ? t.id() : "null"));
                            continue block18;
                        }
                        case sourceId: {
                            fieldList.add(new StringField(t.sourceId() != null ? t.sourceId() : "null"));
                            continue block18;
                        }
                        case uri: {
                            fieldList.add(new StringField(t.uri() != null ? t.uri().toASCIIString() : "null"));
                            continue block18;
                        }
                        case payload: {
                            String payload = XMLBindings.toString((Tree)t);
                            fieldList.add(new StringField(payload != null ? payload : "null"));
                            continue block18;
                        }
                        default: {
                            log.warn("Unexpected field: " + field.getName());
                        }
                    }
                }
                GenericRecord rec = new GenericRecord();
                rec.setFields(fieldList.toArray(new Field[fieldList.size()]));
                log.debug("Returning next row with id: " + t.id());
                if (!this.writer.importRecord((Record)rec, this.timeout, this.timeUnit)) {
                    if (this.writer.getStatus() == IBuffer.Status.Open) {
                        log.warn("Consumer has timed out");
                    } else {
                        log.warn("Consumer has closed");
                    }
                    break;
                }
                if (++rc != 1) continue;
                firstOutputStop = Calendar.getInstance().getTimeInMillis();
            }
        }
        catch (Exception e) {
            log.error("Error during datasource retrieval. Closing", (Throwable)e);
        }
        finally {
            try {
                this.writer.close();
            }
            catch (Exception ee) {}
        }
        long closeStop = Calendar.getInstance().getTimeInMillis();
        log.info("DATASOURCE OPERATOR:Produced first result in " + (firstOutputStop - start) + " milliseconds\n" + "Produced last result in " + (closeStop - start) + " milliseconds\n" + "Produced " + rc + " results\n" + "Production rate was " + (float)rc / (float)(closeStop - start) * 1000.0f + " records per second");
    }

    @Override
    public URI getLocator() {
        if (this.writer != null) {
            try {
                return this.writer.getLocator();
            }
            catch (GRS2WriterException e) {
                log.error("Could not retrieve locator", (Throwable)e);
            }
        }
        return null;
    }

    private static FieldDefinition[] initializeSchema(String filterMask) {
        ArrayList<StringFieldDefinition> fieldDefsList = new ArrayList<StringFieldDefinition>();
        if (filterMask == null) {
            filterMask = "[";
            for (FieldNaming.TMFieldName tMFieldName : FieldNaming.TMFieldName.values()) {
                filterMask = filterMask + tMFieldName.name() + ", ";
            }
            filterMask = filterMask.substring(0, filterMask.length() - 2);
            filterMask = filterMask + "]";
        }
        if (filterMask.replaceAll("[\\[\\],\\s]", "").matches("\\d*")) {
            for (String string : filterMask.replaceAll("[\\[\\]\\s]", "").split(",")) {
                int index = Integer.parseInt(string);
                if (index >= FieldNaming.TMFieldName.values().length) {
                    log.warn("Filter mask out of range");
                    continue;
                }
                fieldDefsList.add(new StringFieldDefinition(FieldNaming.TMFieldName.values()[index].name()));
            }
        } else {
            for (String string : filterMask.replaceAll("[\\[\\]\\s]", "").split(",")) {
                try {
                    switch (FieldNaming.TMFieldName.valueOf(string)) {
                        default: 
                    }
                    fieldDefsList.add(new StringFieldDefinition(FieldNaming.TMFieldName.valueOf(string).name()));
                }
                catch (IllegalArgumentException e) {
                    log.warn("Filter mask out of range for value: " + string);
                }
            }
        }
        log.info("ResultSet schema that will be used: " + fieldDefsList);
        return fieldDefsList.toArray(new FieldDefinition[fieldDefsList.size()]);
    }
}

