/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.storagehub;

import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.List;
import org.gcube.common.authorization.utils.manager.SecretManager;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.common.storagehub.client.dsl.ContainerType;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.ItemContainer;
import org.gcube.common.storagehub.client.dsl.ListResolver;
import org.gcube.common.storagehub.client.dsl.ListResolverTyped;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.model.Metadata;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.storagehub.MetadataMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageHubManagement {
    private static final Logger logger = LoggerFactory.getLogger(StorageHubManagement.class);
    protected MetadataMatcher metadataMatcher;
    protected final StorageHubClient storageHubClient = new StorageHubClient();
    protected FileContainer persitedFile;
    protected String mimeType;

    public void setCheckMetadata(MetadataMatcher checkMetadata) {
        this.metadataMatcher = checkMetadata;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public FileContainer getPersistedFile() {
        return this.persitedFile;
    }

    protected void recursiveList(FolderContainer folder, int level) throws StorageHubException {
        ListResolverTyped listResolverTyped = folder.list();
        List containers = listResolverTyped.includeHidden().getContainers();
        for (ItemContainer itemContainer : containers) {
            Item item = itemContainer.get();
            String name = item.getName();
            ContainerType containerType = itemContainer.getType();
            StringWriter indent = new StringWriter(level + 1);
            for (int i = 0; i < level + 1; ++i) {
                indent.append('-');
            }
            logger.debug("{} {} {} (ID:{}) {}", new Object[]{indent.toString(), containerType, name, itemContainer.getId(), item.isHidden() ? " (hidden)" : ""});
            switch (containerType) {
                case FOLDER: {
                    FolderContainer folderContainer = (FolderContainer)itemContainer;
                    this.recursiveList(folderContainer, level + 1);
                    break;
                }
                case FILE: {
                    break;
                }
                case GENERIC_ITEM: {
                    break;
                }
            }
        }
    }

    protected FolderContainer getWorkspaceRoot() {
        return this.storageHubClient.getWSRoot();
    }

    protected FolderContainer getOrCreateFolder(FolderContainer parent, String name, String description, boolean hidden) throws Exception {
        FolderContainer destinationFolder = null;
        ListResolverTyped listResolverTyped = parent.list();
        List containers = listResolverTyped.includeHidden().getContainers();
        for (ItemContainer itemContainer : containers) {
            if (!(itemContainer instanceof FolderContainer) || itemContainer.get().getName().compareTo(name) != 0) continue;
            destinationFolder = (FolderContainer)itemContainer;
        }
        if (destinationFolder == null) {
            destinationFolder = hidden ? parent.newHiddenFolder(name, description) : parent.newFolder(name, description);
        }
        return destinationFolder;
    }

    protected FolderContainer getContextFolder() throws Exception {
        FolderContainer destinationFolder = this.getWorkspaceRoot();
        String currentContext = SecretManagerProvider.instance.get().getContext();
        ScopeBean scopeBean = new ScopeBean(currentContext);
        switch (scopeBean.type()) {
            case INFRASTRUCTURE: 
            case VO: {
                String folderName = currentContext.replaceFirst("/", "").replace("/", "_");
                destinationFolder = this.getOrCreateFolder(destinationFolder, folderName, "", false);
                break;
            }
            case VRE: {
                destinationFolder = this.storageHubClient.openVREFolder();
                break;
            }
        }
        return destinationFolder;
    }

    public FolderContainer getApplicationFolder() throws Exception {
        FolderContainer destinationFolder = this.getContextFolder();
        SecretManager secretManager = SecretManagerProvider.instance.get();
        String currentContext = secretManager.getContext();
        ScopeBean scopeBean = new ScopeBean(currentContext);
        if (scopeBean.is(ScopeBean.Type.VRE)) {
            String username = secretManager.getUser().getUsername();
            destinationFolder = this.getOrCreateFolder(destinationFolder, username, "Folder Created for user/application", true);
        }
        return destinationFolder;
    }

    public FolderContainer getDestinationFolder(String mimeType) throws Exception {
        String[] splittedMimeType;
        FolderContainer destinationFolder = this.getApplicationFolder();
        for (String name : splittedMimeType = mimeType.split("/")) {
            destinationFolder = this.getOrCreateFolder(destinationFolder, name, "Folder Created using mimetype", false);
        }
        return destinationFolder;
    }

    protected boolean isPersistedFile(FileContainer fileContainer, String filename) {
        if (((AbstractFileItem)fileContainer.get()).getName().startsWith(filename)) {
            if (this.metadataMatcher != null) {
                Metadata metadata = ((AbstractFileItem)fileContainer.get()).getMetadata();
                return this.metadataMatcher.check(metadata);
            }
            return true;
        }
        return false;
    }

    protected void tree(FolderContainer folderContainer) throws Exception {
        logger.debug("{} (ID:{})", (Object)((FolderItem)folderContainer.get()).getName(), (Object)folderContainer.getId());
        this.recursiveList(folderContainer, 0);
    }

    public URL persistFile(InputStream inputStream, String fileName, String mimeType, Metadata metadata) throws Exception {
        this.mimeType = mimeType;
        FolderContainer destinationFolder = this.getDestinationFolder(mimeType);
        this.persitedFile = destinationFolder.uploadFile(inputStream, fileName, "This file has been created to ensure persistence");
        if (metadata != null) {
            this.persitedFile.setMetadata(metadata);
        }
        URL finalURL = this.persitedFile.getPublicLink();
        logger.debug("File persistence has been ensured. The file is available at {}", (Object)finalURL);
        return finalURL;
    }

    public FileContainer getPersistedFile(String filename, String mimeType) throws Exception {
        FolderContainer destinationFolder = this.getDestinationFolder(mimeType);
        ListResolver listResolver = destinationFolder.findByName(filename);
        List itemContainers = listResolver.withMetadata().getContainers();
        for (ItemContainer itemContainer : itemContainers) {
            if (itemContainer.getType() != ContainerType.FILE || !this.isPersistedFile((FileContainer)itemContainer, filename)) continue;
            this.persitedFile = (FileContainer)itemContainer;
            return this.persitedFile;
        }
        return this.persitedFile;
    }

    public void removePersistedFile(String filename, String mimeType) throws Exception {
        this.getPersistedFile(filename, mimeType);
        if (this.persitedFile != null) {
            this.persitedFile.delete();
        }
    }
}

