/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.social;

import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.gcat.persistence.ckan.CKANInstance;
import org.gcube.gcat.persistence.ckan.CKANUserCache;
import org.gcube.gcat.social.SocialService;
import org.gcube.gcat.utils.Constants;
import org.gcube.gcat.utils.ContextUtility;
import org.gcube.gcat.utils.HTTPUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocialPost
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(SocialPost.class);
    public static final String ITEM_URL = "Item URL";
    protected static final String SOCIAL_SERVICE_WRITE_APPLICATION_POST_PATH = "/2/posts/write-post-app";
    protected static final String NOTIFICATION_MESSAGE = "%s just published the item \"%s\"\nPlease find it at %s\n";
    protected static final String SOCIAL_POST_TEXT_KEY = "text";
    protected static final String SOCIAL_POST_ENABLE_NOTIFICATION_KEY = "enable_notification";
    protected static final String SOCIAL_POST_RESPONSE_SUCCESS_KEY = "success";
    protected static final String SOCIAL_POST_RESPONSE_MESSAGE_KEY = "message";
    protected final ObjectMapper objectMapper = new ObjectMapper();
    protected String itemID;
    protected String itemURL;
    protected String itemTitle;
    protected List<String> tags;

    public String getItemID() {
        return this.itemID;
    }

    public void setItemID(String itemID) {
        this.itemID = itemID;
    }

    public String getItemURL() {
        return this.itemURL;
    }

    public void setItemURL(String itemURL) {
        this.itemURL = itemURL;
    }

    public String getItemTitle() {
        return this.itemTitle;
    }

    public void setItemTitle(String itemTitle) {
        this.itemTitle = itemTitle;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setTags(ArrayNode tags) {
        this.tags = new ArrayList();
        if (tags != null && tags.size() > 0) {
            for (int i = 0; i < tags.size(); ++i) {
                JsonNode jsonNode = tags.get(i);
                String tagName = "";
                tagName = jsonNode.has("display_name") ? jsonNode.get("display_name").asText() : jsonNode.get("name").asText();
                this.tags.add(tagName);
            }
        }
    }

    @Override
    public void run() {
        try {
            CKANInstance instance = CKANInstance.getInstance();
            if (!instance.isSocialPostEnabled()) {
                logger.info("Social Post are disabled in the context {}", (Object)ContextUtility.getCurrentContext());
                return;
            }
            logger.info("Going to send Social Post about the Item {} available at {}", (Object)this.itemID, (Object)this.itemURL);
            boolean notifyUsers = instance.isNotificationToUsersEnabled();
            this.sendSocialPost(notifyUsers);
        }
        catch (Exception e) {
            logger.error("Error while executing post creation actions", (Throwable)e);
        }
    }

    public void sendSocialPost(boolean notifyUsers) {
        try {
            String fullName = CKANUserCache.getCurrrentCKANUser().getPortalUser().getFullName();
            String basePath = SocialService.getSocialService().getServiceBasePath();
            if (basePath == null) {
                logger.info("Unable to write a post because there is no social networking service available");
                return;
            }
            basePath = basePath.endsWith("/") ? basePath : basePath + "/";
            StringWriter messageWriter = new StringWriter();
            messageWriter.append(String.format(NOTIFICATION_MESSAGE, fullName, this.itemTitle, this.itemURL));
            for (String tag : this.tags) {
                tag = tag.trim();
                if ((tag = tag.replaceAll(" ", "_").replace("_+", "_")).endsWith("_")) {
                    tag = tag.substring(0, tag.length() - 1);
                }
                messageWriter.append("#");
                messageWriter.append(tag);
                messageWriter.append(" ");
            }
            String message = messageWriter.toString();
            logger.debug("The post that is going to be written is\n{}", (Object)message);
            ObjectNode objectNode = this.objectMapper.createObjectNode();
            objectNode.put(SOCIAL_POST_TEXT_KEY, message);
            objectNode.put(SOCIAL_POST_ENABLE_NOTIFICATION_KEY, notifyUsers);
            GXHTTPStringRequest gxhttpStringRequest = GXHTTPStringRequest.newRequest((String)basePath);
            gxhttpStringRequest.from("gCat");
            gxhttpStringRequest.header("Content-Type", "application/json");
            gxhttpStringRequest.setSecurityToken(Constants.getCatalogueApplicationToken());
            gxhttpStringRequest.path(SOCIAL_SERVICE_WRITE_APPLICATION_POST_PATH);
            HttpURLConnection httpURLConnection = gxhttpStringRequest.post(this.objectMapper.writeValueAsString((Object)objectNode));
            String ret = HTTPUtility.getResultAsString((HttpURLConnection)httpURLConnection);
            JsonNode jsonNode = this.objectMapper.readTree(ret);
            if (jsonNode.get(SOCIAL_POST_RESPONSE_SUCCESS_KEY).asBoolean()) {
                logger.info("Post written : {}", (Object)message);
            } else {
                logger.info("Failed to write the post {}. Reason {}", (Object)message, (Object)jsonNode.get(SOCIAL_POST_RESPONSE_MESSAGE_KEY).asText());
            }
        }
        catch (Exception e) {
            logger.error("Unable to send Social Post", (Throwable)e);
        }
    }
}

