/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.persistence.ckan;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.gcat.oldutils.Validator;
import org.gcube.gcat.persistence.ckan.CKAN;
import org.gcube.gcat.persistence.ckan.CKANLicense;
import org.gcube.gcat.persistence.ckan.CKANOrganization;
import org.gcube.gcat.persistence.ckan.CKANResource;
import org.gcube.gcat.persistence.ckan.CKANUser;
import org.gcube.gcat.persistence.ckan.CKANUserCache;
import org.gcube.gcat.persistence.ckan.CKANUtility;
import org.gcube.gcat.profile.MetadataUtility;
import org.gcube.gcat.social.SocialPost;
import org.gcube.gcat.utils.ContextUtility;
import org.gcube.gcat.utils.URIResolver;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
public class CKANPackage
extends CKAN {
    private static final Logger logger = LoggerFactory.getLogger(CKANPackage.class);
    public static final String ITEM_LIST = "/api/3/action/package_search";
    public static final String ITEM_CREATE = "/api/3/action/package_create";
    public static final String ITEM_SHOW = "/api/3/action/package_show";
    public static final String ITEM_UPDATE = "/api/3/action/package_update";
    public static final String ITEM_PATCH = "/api/3/action/package_patch";
    public static final String ITEM_DELETE = "/api/3/action/package_delete";
    public static final String ITEM_PURGE = "/api/3/action/dataset_purge";
    protected static final String ROWS_KEY = "rows";
    protected static final String START_KEY = "start";
    protected static final String ORGANIZATION_FILTER_TEMPLATE = "organization:%s";
    protected static final String ORGANIZATION_REGEX = "organization:[a-zA-Z0-9_\"]*";
    protected static final Pattern ORGANIZATION_REGEX_PATTERN = Pattern.compile("organization:[a-zA-Z0-9_\"]*");
    public static final String GENERIC_RESOURCE_SECONDARY_TYPE_FOR_ORGANIZATIONS = "ApplicationProfile";
    public static final String GENERIC_RESOURCE_NAME_FOR_ORGANIZATIONS = "Supported CKAN Organizations";
    public static final String GENERIC_RESOURCE_TAG_NAME = "CKANOrganization";
    public static final String GENERIC_RESOURCE_TAG_NAME_PLURAL = "CKANOrganizations";
    protected static final String LICENSE_KEY = "license_id";
    protected static final String EXTRAS_ITEM_URL_KEY = "Item URL";
    protected static final String AUTHOR_KEY = "author";
    protected static final String AUTHOR_EMAIL_KEY = "author_email";
    protected static final String OWNER_ORG_KEY = "owner_org";
    protected static final String RESOURCES_KEY = "resources";
    protected static final String TITLE_KEY = "title";
    public static final String EXTRAS_KEY = "extras";
    public static final String EXTRAS_KEY_KEY = "key";
    public static final String EXTRAS_KEY_VALUE_SYSTEM_TYPE = "system:type";
    public static final String EXTRAS_VALUE_KEY = "value";
    private static final String RESULTS_KEY = "results";
    protected static final String PRIVATE_KEY = "private";
    protected static final String SEARCHABLE_KEY = "searchable";
    protected static final String CAPACITY_KEY = "capacity";
    public static final String GROUPS_KEY = "groups";
    public static final String TAGS_KEY = "tags";
    protected final List<CKANResource> managedResources;
    protected String itemID;
    protected ScopeBean currentScopeBean;
    protected String currentContext;
    protected String currentOrganizationName;
    protected Set<String> supportedOrganizations;
    protected static String[] allowedListQueryParameters = new String[]{"q", "fq", "fq_list", "sort", "include_drafts", "include_private", "ext_bbox"};

    public CKANPackage() {
        this.LIST = "/api/3/action/package_search";
        this.CREATE = "/api/3/action/package_create";
        this.READ = "/api/3/action/package_show";
        this.UPDATE = "/api/3/action/package_update";
        this.PATCH = "/api/3/action/package_patch";
        this.DELETE = "/api/3/action/package_delete";
        this.PURGE = "/api/3/action/dataset_purge";
        this.managedResources = new ArrayList();
        this.getCurrentContext();
        this.getSupportedOrganizationsFromIS();
    }

    protected Set<String> getSupportedOrganizationsFromIS() {
        if (this.supportedOrganizations == null) {
            this.supportedOrganizations = new HashSet();
            XQuery query = ICFactory.queryFor(GenericResource.class);
            query.addCondition(String.format("$resource/Profile/SecondaryType/text() eq '%s'", "ApplicationProfile"));
            query.addCondition(String.format("$resource/Profile/Name/text() eq '%s'", "Supported CKAN Organizations"));
            DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
            List resources = client.submit((Query)query);
            if (resources == null || resources.size() == 0) {
                logger.info("{} with SecondaryType {} and Name %s not found. Item will be only be created in {} CKAN organization", new Object[]{GenericResource.class.getSimpleName(), "ApplicationProfile", "Supported CKAN Organizations", this.getOrganizationName()});
                this.supportedOrganizations.add(this.getOrganizationName());
            } else {
                GenericResource genericResource = (GenericResource)resources.get(0);
                NodeList nodeList = genericResource.profile().body().getChildNodes();
                if (nodeList != null && nodeList.getLength() > 0) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        NodeList nl = nodeList.item(i).getChildNodes();
                        String organization = nl.item(0).getNodeValue();
                        this.supportedOrganizations.add(organization);
                    }
                }
            }
        }
        CKANUser ckanUser = CKANUserCache.getCurrrentCKANUser();
        for (String supportedOrganization : this.supportedOrganizations) {
            ckanUser.addUserToOrganization(supportedOrganization);
        }
        logger.debug("Supported CKAN Organization for current Context ({}) are {}", (Object)this.getCurrentContext(), (Object)this.supportedOrganizations);
        return this.supportedOrganizations;
    }

    protected static String getOrganizationName(ScopeBean scopeBean) {
        String contextName = scopeBean.name();
        return contextName.toLowerCase().replace(" ", "_");
    }

    protected String getCurrentContext() {
        if (this.currentContext == null) {
            this.currentContext = ContextUtility.getCurrentContext();
            this.currentScopeBean = new ScopeBean(this.currentContext);
        }
        return this.currentContext;
    }

    protected String getOrganizationName() {
        if (this.currentOrganizationName == null) {
            this.currentOrganizationName = CKANPackage.getOrganizationName((ScopeBean)this.currentScopeBean);
        }
        return this.currentOrganizationName;
    }

    protected CKANOrganization checkGotOrganization(String gotOrganization) throws ForbiddenException {
        if (!this.supportedOrganizations.contains(gotOrganization)) {
            String error = String.format("IS Configuration does not allow to publish in %s organizations. Allowed organization are: %s", gotOrganization, this.supportedOrganizations);
            throw new ForbiddenException(error);
        }
        CKANOrganization ckanOrganization = new CKANOrganization();
        ckanOrganization.setName(gotOrganization);
        ckanOrganization.read();
        return ckanOrganization;
    }

    protected CKANOrganization getPublishingOrganization(ObjectNode objectNode) throws ForbiddenException {
        CKANOrganization ckanOrganization = null;
        if (objectNode.has("owner_org")) {
            String gotOrganizationName = objectNode.get("owner_org").asText();
            ckanOrganization = this.checkGotOrganization(gotOrganizationName);
        }
        if (ckanOrganization == null) {
            String organizationFromContext = this.getOrganizationName();
            ckanOrganization = this.checkGotOrganization(organizationFromContext);
            objectNode.put("owner_org", organizationFromContext);
        }
        return ckanOrganization;
    }

    public ObjectNode checkBaseInformation(String json) throws Exception {
        return this.checkBaseInformation(json, false);
    }

    public ObjectNode checkBaseInformation(String json, boolean allowPartialInfo) throws Exception {
        boolean privatePackage;
        ObjectNode objectNode;
        block11: {
            objectNode = (ObjectNode)this.mapper.readTree(json);
            try {
                objectNode = (ObjectNode)this.checkName((JsonNode)objectNode);
            }
            catch (Exception e) {
                if (allowPartialInfo) break block11;
                throw e;
            }
        }
        if (objectNode.has("id")) {
            this.itemID = objectNode.get("id").asText();
        }
        if (objectNode.has("private") && (privatePackage = objectNode.get("private").asBoolean())) {
            objectNode.put("searchable", true);
        }
        String licenseId = null;
        if (objectNode.has("license_id")) {
            licenseId = objectNode.get("license_id").asText();
        }
        if (licenseId != null && !licenseId.isEmpty()) {
            try {
                CKANLicense.checkLicenseId((String)licenseId);
            }
            catch (Exception e) {
                throw new BadRequestException("You must specify an existing license identifier for the item. License list can be retrieved using licence collection");
            }
        } else if (!allowPartialInfo) {
            throw new BadRequestException("You must specify a license identifier for the item. License list can be retrieved using licence collection");
        }
        if (objectNode.has("capacity")) {
            objectNode.remove("capacity");
        }
        CKANUser ckanUser = CKANUserCache.getCurrrentCKANUser();
        objectNode.put("author", ckanUser.getName());
        objectNode.put("author_email", ckanUser.getPortalUser().getEMail());
        this.getPublishingOrganization(objectNode);
        return objectNode;
    }

    protected JsonNode validateJson(String json) {
        try {
            ObjectNode objectNode = this.checkBaseInformation(json);
            MetadataUtility metadataUtility = new MetadataUtility();
            if (!metadataUtility.getMetadataProfiles().isEmpty()) {
                Validator validator = new Validator(this.mapper);
                objectNode = validator.validateAgainstProfile(objectNode, metadataUtility);
            }
            return objectNode;
        }
        catch (BadRequestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BadRequestException((Throwable)e);
        }
    }

    public int count() {
        Map<String, String> parameters = new HashMap<String, String>();
        if (this.uriInfo != null) {
            MultivaluedMap queryParameters = this.uriInfo.getQueryParameters();
            parameters = this.checkListParameters(queryParameters, parameters);
        }
        int limit = 1;
        parameters.put("rows", String.valueOf(limit));
        int offset = 0;
        parameters.put("start", String.valueOf(offset * limit));
        if (!parameters.containsKey("q")) {
            String filter = this.getFilterForOrganizations();
            parameters.put("q", filter);
        }
        this.sendGetRequest(this.LIST, parameters);
        int count = this.result.get("count").asInt();
        return count;
    }

    public String list(int limit, int offset) {
        Map<String, String> parameters = new HashMap<String, String>();
        if (limit <= 0) {
            limit = 1000;
        }
        parameters.put("rows", String.valueOf(limit));
        if (offset < 0) {
            offset = 0;
        }
        parameters.put("start", String.valueOf(offset * limit));
        if (this.uriInfo != null) {
            MultivaluedMap queryParameters = this.uriInfo.getQueryParameters();
            parameters = this.checkListParameters(queryParameters, parameters);
        }
        if (!parameters.containsKey("q")) {
            String filter = this.getFilterForOrganizations();
            parameters.put("q", filter);
        }
        return this.list(parameters);
    }

    protected Set<String> checkOrganizationFilter(String q) {
        Matcher m = ORGANIZATION_REGEX_PATTERN.matcher(q);
        HashSet<String> matches = new HashSet<String>();
        while (m.find()) {
            matches.add(q.substring(m.start(), m.end()).replace("organization:", ""));
        }
        return matches;
    }

    protected String getFilterForOrganizations() {
        StringWriter stringWriter = new StringWriter();
        int i = 1;
        for (String organizationName : this.supportedOrganizations) {
            stringWriter.append(String.format("organization:%s", organizationName));
            if (i != this.supportedOrganizations.size()) {
                stringWriter.append(" OR ");
            }
            ++i;
        }
        return stringWriter.toString();
    }

    protected Map<String, String> checkListParameters(MultivaluedMap<String, String> queryParameters, Map<String, String> parameters) {
        String q = null;
        if (queryParameters.containsKey((Object)"q")) {
            q = (String)queryParameters.getFirst((Object)"q");
        }
        if (q != null) {
            Set organizations = this.checkOrganizationFilter(q);
            if (organizations.size() == 0) {
                String filter = this.getFilterForOrganizations();
                parameters.put("q", String.format("%s AND %s", q, filter));
            } else {
                organizations.removeAll(this.supportedOrganizations);
                if (organizations.size() > 0) {
                    String error = String.format("It is not possible to query the following organizations %s. Supported organization in this context are %s", organizations.toString(), this.supportedOrganizations.toString());
                    throw new ForbiddenException(error);
                }
            }
        } else {
            String filter = this.getFilterForOrganizations();
            parameters.put("q", filter);
        }
        for (String key : allowedListQueryParameters) {
            if (!queryParameters.containsKey((Object)key)) continue;
            parameters.put(key, (String)queryParameters.getFirst((Object)key));
        }
        return parameters;
    }

    public String list(Map<String, String> parameters) {
        this.sendGetRequest(this.LIST, parameters);
        ArrayNode results = (ArrayNode)this.result.get("results");
        ArrayNode arrayNode = this.mapper.createArrayNode();
        for (JsonNode node : results) {
            try {
                String name = node.get("name").asText();
                arrayNode.add(name);
            }
            catch (Exception e) {
                try {
                    logger.error("Unable to get the ID of {}. the result will not be included in the result", (Object)this.mapper.writeValueAsString((Object)node));
                }
                catch (Exception ex) {
                    logger.error("", (Throwable)ex);
                }
            }
        }
        return this.getAsString((JsonNode)arrayNode);
    }

    protected void rollbackManagedResources() {
        for (CKANResource ckanResource : this.managedResources) {
            try {
                ckanResource.rollback();
            }
            catch (Exception e) {
                logger.error("Unable to rollback resource {} to the original value", (Object)ckanResource.getResourceID());
            }
        }
    }

    protected ArrayNode createResources(ArrayNode resourcesToBeCreated) {
        ArrayNode created = this.mapper.createArrayNode();
        for (JsonNode resourceNode : resourcesToBeCreated) {
            CKANResource ckanResource = new CKANResource(this.itemID);
            String json = ckanResource.create(this.getAsString(resourceNode));
            created.add(this.getAsJsonNode(json));
            this.managedResources.add(ckanResource);
        }
        return created;
    }

    protected JsonNode addExtraField(JsonNode jsonNode, String key, String value) {
        ArrayNode extras = null;
        boolean found = false;
        if (jsonNode.has("extras")) {
            extras = (ArrayNode)jsonNode.get("extras");
            for (JsonNode extra : extras) {
                if (!extra.has("key") || extra.get("key").asText().compareTo(key) != 0) continue;
                ((ObjectNode)extra).put("value", value);
                found = true;
                break;
            }
        } else {
            extras = this.mapper.createArrayNode();
        }
        if (!found) {
            ObjectNode extra = this.mapper.createObjectNode();
            extra.put("key", key);
            extra.put("value", value);
            extras.add((JsonNode)extra);
        }
        return jsonNode;
    }

    protected String addItemURLViaResolver(JsonNode jsonNode) {
        URIResolver uriResolver = new URIResolver();
        String catalogueItemURL = uriResolver.getCatalogueItemURL(this.name);
        this.addExtraField(jsonNode, "Item URL", catalogueItemURL);
        return catalogueItemURL;
    }

    protected void sendSocialPost(String title, String catalogueItemURL) {
        try {
            boolean socialPost = false;
            try {
                MultivaluedMap queryParameters = this.uriInfo.getQueryParameters();
                if (queryParameters.containsKey((Object)"social_post")) {
                    socialPost = Boolean.parseBoolean((String)queryParameters.getFirst((Object)"social_post"));
                }
            }
            catch (Exception e) {
                socialPost = false;
            }
            if (socialPost) {
                ArrayNode arrayNode = (ArrayNode)this.result.get("tags");
                SocialPost socialService = new SocialPost();
                socialService.setItemID(this.itemID);
                socialService.setItemURL(catalogueItemURL);
                socialService.setTags(arrayNode);
                socialService.setItemTitle(title);
                socialService.start();
            } else {
                logger.info("The request explicitly disabled the Social Post.");
            }
        }
        catch (Exception e) {
            logger.warn("error dealing with Social Post. The service will not raise the exception belove. Please contact the administrator to let him know about this message.", (Throwable)e);
        }
    }

    public String create(String json) {
        try {
            logger.debug("Going to create Item {}", (Object)json);
            JsonNode jsonNode = this.validateJson(json);
            ArrayNode resourcesToBeCreated = this.mapper.createArrayNode();
            if (jsonNode.has("resources")) {
                resourcesToBeCreated = (ArrayNode)jsonNode.get("resources");
                ((ObjectNode)jsonNode).remove("resources");
            }
            String catalogueItemURL = "";
            if (this.currentScopeBean.is(ScopeBean.Type.VRE)) {
                catalogueItemURL = this.addItemURLViaResolver(jsonNode);
            }
            super.create(this.getAsString(jsonNode));
            this.itemID = this.result.get("id").asText();
            ArrayNode created = this.createResources(resourcesToBeCreated);
            ((ObjectNode)this.result).replace("resources", (JsonNode)created);
            String title = this.result.get("title").asText();
            if (this.currentScopeBean.is(ScopeBean.Type.VRE)) {
                this.sendSocialPost(title, catalogueItemURL);
            }
            return this.getAsString(this.result);
        }
        catch (WebApplicationException e) {
            this.rollbackManagedResources();
            throw e;
        }
        catch (Exception e) {
            this.rollbackManagedResources();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public String update(String json) {
        try {
            Object ckanResource;
            JsonNode jsonNode = this.validateJson(json);
            this.read();
            this.itemID = this.result.get("id").asText();
            HashMap<String, Object> originalResources = new HashMap<String, Object>();
            ArrayNode originalResourcesarrayNode = (ArrayNode)this.result.get("resources");
            if (originalResources != null) {
                for (JsonNode resourceNode : originalResourcesarrayNode) {
                    ckanResource = new CKANResource(this.itemID);
                    ckanResource.setPreviousRepresentation(resourceNode);
                    String resourceID = ckanResource.getResourceID();
                    originalResources.put(resourceID, ckanResource);
                }
            }
            if (jsonNode.has("resources")) {
                ArrayNode resourcesToBeSend = this.mapper.createArrayNode();
                ArrayNode receivedResources = (ArrayNode)jsonNode.get("resources");
                for (JsonNode resourceNode : receivedResources) {
                    CKANResource ckanResource2 = new CKANResource(this.itemID);
                    String resourceId = CKANResource.extractResourceID((JsonNode)resourceNode);
                    if (resourceId != null) {
                        if (originalResources.containsKey(resourceId)) {
                            ckanResource2 = (CKANResource)originalResources.get(resourceId);
                            originalResources.remove(resourceId);
                        } else {
                            throw new BadRequestException("The content contains a resource with id " + resourceId + " which does not exists");
                        }
                    }
                    if (originalResources.get(resourceId) != null && !((CKANResource)originalResources.get(resourceId)).getPreviousRepresentation().equals((Object)resourceNode)) {
                        resourceNode = ckanResource2.createOrUpdate(resourceNode);
                    }
                    resourcesToBeSend.add(resourceNode);
                    this.managedResources.add(ckanResource2);
                }
                ((ObjectNode)jsonNode).replace("resources", (JsonNode)resourcesToBeSend);
            }
            this.addItemURLViaResolver(jsonNode);
            this.sendPostRequest("/api/3/action/package_update", this.getAsString(jsonNode));
            for (String resourceId : originalResources.keySet()) {
                ckanResource = (CKANResource)originalResources.get(resourceId);
                ckanResource.deleteFile();
            }
            return this.getAsString(this.result);
        }
        catch (WebApplicationException e) {
            this.rollbackManagedResources();
            throw e;
        }
        catch (Exception e) {
            this.rollbackManagedResources();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public String patch(String json) {
        try {
            Object ckanResource;
            ObjectNode jsonNode = this.checkBaseInformation(json, true);
            this.read();
            this.itemID = this.result.get("id").asText();
            jsonNode.put("id", this.itemID);
            HashMap<String, Object> originalResources = new HashMap<String, Object>();
            ArrayNode originalResourcesarrayNode = (ArrayNode)this.result.get("resources");
            if (originalResources != null) {
                for (JsonNode resourceNode : originalResourcesarrayNode) {
                    ckanResource = new CKANResource(this.itemID);
                    ckanResource.setPreviousRepresentation(resourceNode);
                    String resourceID = ckanResource.getResourceID();
                    originalResources.put(resourceID, ckanResource);
                }
            }
            if (jsonNode.has("resources")) {
                ArrayNode resourcesToBeSend = this.mapper.createArrayNode();
                ArrayNode receivedResources = (ArrayNode)jsonNode.get("resources");
                for (JsonNode resourceNode : receivedResources) {
                    CKANResource ckanResource2 = new CKANResource(this.itemID);
                    String resourceId = CKANResource.extractResourceID((JsonNode)resourceNode);
                    if (resourceId != null) {
                        if (originalResources.containsKey(resourceId)) {
                            ckanResource2 = (CKANResource)originalResources.get(resourceId);
                            originalResources.remove(resourceId);
                        } else {
                            throw new BadRequestException("The content contains a resource with id " + resourceId + " which does not exists");
                        }
                    }
                    if (originalResources.get(resourceId) != null && !((CKANResource)originalResources.get(resourceId)).getPreviousRepresentation().equals((Object)resourceNode)) {
                        resourceNode = ckanResource2.createOrUpdate(resourceNode);
                    }
                    resourcesToBeSend.add(resourceNode);
                    this.managedResources.add(ckanResource2);
                }
                jsonNode.replace("resources", (JsonNode)resourcesToBeSend);
            }
            this.addItemURLViaResolver((JsonNode)jsonNode);
            this.sendPostRequest("/api/3/action/package_patch", this.getAsString((JsonNode)jsonNode));
            for (String resourceId : originalResources.keySet()) {
                ckanResource = (CKANResource)originalResources.get(resourceId);
                ckanResource.deleteFile();
            }
            return this.getAsString(this.result);
        }
        catch (WebApplicationException e) {
            this.rollbackManagedResources();
            throw e;
        }
        catch (Exception e) {
            this.rollbackManagedResources();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    protected void delete() {
        super.delete();
    }

    public void purge() {
        block4: {
            try {
                this.delete();
            }
            catch (WebApplicationException e) {
                Response.Status status = Response.Status.fromStatusCode((int)e.getResponse().getStatusInfo().getStatusCode());
                if (status == Response.Status.NOT_FOUND) break block4;
                throw e;
            }
        }
        this.setApiKey(CKANUtility.getSysAdminAPI());
        this.read();
        if (this.result.has("resources")) {
            this.itemID = this.result.get("id").asText();
            ArrayNode arrayNode = (ArrayNode)this.result.get("resources");
            for (JsonNode jsonNode : arrayNode) {
                CKANResource ckanResource = new CKANResource(this.itemID);
                ckanResource.setPreviousRepresentation(jsonNode);
                ckanResource.deleteFile();
            }
        }
        super.purge();
    }
}

