/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.persistence.ckan;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PUT;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.io.FilenameUtils;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypes;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.gcat.persistence.ckan.CKAN;
import org.gcube.gcat.persistence.ckan.CKANPackage;
import org.gcube.gcat.utils.ContextUtility;
import org.gcube.gcat.utils.HTTPCall;
import org.gcube.gcat.workspace.CatalogueStorageHubManagement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CKANResource
extends CKAN {
    private static final Logger logger = LoggerFactory.getLogger(CKANResource.class);
    public static final String RESOURCE_CREATE = "/api/3/action/resource_create";
    public static final String RESOURCE_SHOW = "/api/3/action/resource_show";
    public static final String RESOURCE_UPDATE = "/api/3/action/resource_update";
    public static final String RESOURCE_PATCH = "/api/3/action/resource_patch";
    public static final String RESOURCE_DELETE = "/api/3/action/resource_delete";
    protected static final String URL_KEY = "url";
    private static final String RESOURCES_KEY = "resources";
    private static final String PACKAGE_ID_KEY = "package_id";
    private static final String FORMAT_KEY = "format";
    private static final String MIME_TYPE_KEY = "mimetype";
    private static final String REVISION_ID_KEY = "revision_id";
    private static final String TEMP = "TEMP_";
    public static final String RESOURCE_NAME_REGEX = "^[\\s\\S]*$";
    public static final MimeTypes ALL_MIME_TYPES;
    private static final String URI_RESOLVER_STORAGE_HUB_HOST_PROD = "data.d4science.org";
    private static final String URI_RESOLVER_STORAGE_HUB_HOST_DEV = "data1-d.d4science.org";
    public static final String URI_RESOLVER_STORAGE_HUB_HOST;
    public static final String URI_RESOLVER_STORAGE_HUB_PATH = "/shub/";
    protected String itemID;
    protected String resourceID;
    protected boolean persisted;
    protected URL persistedURL;
    protected String mimeType;
    protected String originalFileExtension;
    protected JsonNode previousRepresentation;
    protected CatalogueStorageHubManagement storageHubManagement;

    public String getItemID() {
        return this.itemID;
    }

    public URL getPersistedURL() {
        return this.persistedURL;
    }

    public static String extractResourceID(JsonNode jsonNode) {
        String resourceID = null;
        if (jsonNode.has("id")) {
            resourceID = jsonNode.get("id").asText();
        }
        return resourceID;
    }

    public String getResourceID() {
        if (this.resourceID == null && this.previousRepresentation != null) {
            this.resourceID = CKANResource.extractResourceID((JsonNode)this.previousRepresentation);
        }
        return this.resourceID;
    }

    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public void setPreviousRepresentation(JsonNode jsonNode) {
        this.validate(jsonNode);
        this.previousRepresentation = jsonNode;
    }

    public JsonNode getPreviousRepresentation() {
        if (this.previousRepresentation == null && this.resourceID != null) {
            this.sendGetRequest(this.READ, this.getMapWithID(this.resourceID));
            this.validate(this.result);
            this.previousRepresentation = this.result;
        }
        return this.previousRepresentation;
    }

    public CKANResource(String itemID) {
        this.nameRegex = "^[\\s\\S]*$";
        this.itemID = itemID;
        this.CREATE = "/api/3/action/resource_create";
        this.READ = "/api/3/action/resource_show";
        this.UPDATE = "/api/3/action/resource_update";
        this.PATCH = "/api/3/action/resource_patch";
        this.DELETE = "/api/3/action/resource_delete";
        this.PURGE = null;
        this.persisted = false;
        this.previousRepresentation = null;
    }

    public String list(int limit, int offeset) {
        return this.list();
    }

    public String list() {
        CKANPackage ckanPackage = new CKANPackage();
        ckanPackage.setName(this.itemID);
        String itemJson = ckanPackage.read();
        JsonNode item = this.getAsJsonNode(itemJson);
        JsonNode resources = item.get("resources");
        return this.getAsString(resources);
    }

    protected String getFormat() {
        String format = null;
        if (this.originalFileExtension != null) {
            format = this.originalFileExtension;
        } else {
            try {
                MimeType mimeTypeClzInstance = ALL_MIME_TYPES.forName(this.mimeType);
                format = mimeTypeClzInstance.getExtension();
                if (format == null || format.compareTo("") == 0) {
                    format = this.mimeType.split("/")[1].split(";")[0];
                }
            }
            catch (Exception e) {
                try {
                    format = this.mimeType.split("/")[1].split(";")[0];
                }
                catch (Exception ex) {
                    format = null;
                }
            }
        }
        if (format != null && format.startsWith(".")) {
            format = format.substring(1);
        }
        return format;
    }

    protected ObjectNode persistStorageFile(ObjectNode objectNode) {
        if (objectNode.has("url")) {
            URL url;
            String urlString = objectNode.get("url").asText();
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                throw new BadRequestException((Throwable)e);
            }
            url = this.copyStorageResource(url);
            if (this.name != null) {
                objectNode.put("name", this.name);
            }
            if (this.mimeType != null) {
                String format;
                objectNode.put("mimetype", this.mimeType);
                if (!objectNode.has("format") && (format = this.getFormat()) != null) {
                    objectNode.put("format", format);
                }
            }
            objectNode.put("url", url.toString());
            return objectNode;
        }
        String error = String.format("The content must contains the %s property", "url");
        throw new BadRequestException(error);
    }

    protected ObjectNode validate(String json) throws MalformedURLException {
        JsonNode jsonNode = this.getAsJsonNode(json);
        return this.validate(jsonNode);
    }

    protected ObjectNode validate(JsonNode jsonNode) {
        ObjectNode objectNode = (ObjectNode)jsonNode;
        if (objectNode.has("package_id")) {
            String packageId = objectNode.get("package_id").asText();
            if (packageId.compareTo(this.itemID) != 0) {
                String error = String.format("Item ID %s does not match %s which is the value of %s contained in the representation.", this.itemID, packageId, "package_id");
                throw new BadRequestException(error);
            }
        } else {
            objectNode.put("package_id", this.itemID);
        }
        if (objectNode.has("id")) {
            String gotId = objectNode.get("id").asText();
            if (this.resourceID == null) {
                this.resourceID = gotId;
            } else if (this.resourceID.compareTo(gotId) != 0) {
                String error = String.format("Resource ID %s does not match %s which is the value of %s contained in the representation.", this.resourceID, gotId, "id");
                throw new BadRequestException(error);
            }
        } else {
            this.resourceID = "TEMP_" + UUID.randomUUID().toString();
            logger.trace("The id of the resource with name {} for package {} has not been provided. It has been generated : {}", new Object[]{this.name, this.itemID, this.resourceID});
        }
        return objectNode;
    }

    protected URL getFinalURL(String url) {
        try {
            URL urlURL = new URL(url);
            return CKANResource.getFinalURL((URL)urlURL);
        }
        catch (MalformedURLException e) {
            throw new BadRequestException((Throwable)e);
        }
    }

    public static URL getFinalURL(URL url) {
        HTTPCall httpCall = new HTTPCall(url.toString());
        httpCall.setgCubeTargetService(false);
        URL finalURL = httpCall.getFinalURL(url);
        return finalURL;
    }

    protected boolean isStorageFile(URL url) {
        URL urlToCheck = url;
        try {
            urlToCheck = CKANResource.getFinalURL((URL)url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (urlToCheck.getHost().compareTo(URI_RESOLVER_STORAGE_HUB_HOST) == 0 && urlToCheck.getPath().startsWith("/shub/")) {
            this.persistedURL = urlToCheck;
            return true;
        }
        return false;
    }

    protected URL copyStorageResource(URL url) {
        this.persistedURL = url;
        if (this.isStorageFile(this.persistedURL)) {
            this.storageHubManagement = new CatalogueStorageHubManagement();
            try {
                this.persistedURL = this.storageHubManagement.ensureResourcePersistence(this.persistedURL, this.itemID, this.resourceID);
                String originalFilename = this.storageHubManagement.getOriginalFilename();
                this.name = FilenameUtils.removeExtension((String)originalFilename);
                this.originalFileExtension = FilenameUtils.getExtension((String)originalFilename);
                this.mimeType = this.storageHubManagement.getMimeType();
                this.persisted = true;
            }
            catch (Exception e) {
                throw new InternalServerErrorException((Throwable)e);
            }
        }
        return this.persistedURL;
    }

    protected void deleteStorageResource(URL url, String resourceID, String mimetype) {
        this.persistedURL = url;
        if (this.isStorageFile(this.persistedURL)) {
            try {
                GXHTTPStringRequest gxhttpStringRequest = GXHTTPStringRequest.newRequest((String)this.persistedURL.toString());
                HttpURLConnection httpURLConnection = gxhttpStringRequest.from("gCat").head();
                String storageHubContentType = httpURLConnection.getContentType().split(";")[0];
                if (mimetype.compareTo(storageHubContentType) != 0) {
                    mimetype = storageHubContentType;
                }
            }
            catch (Exception gxhttpStringRequest) {
                // empty catch block
            }
            this.storageHubManagement = new CatalogueStorageHubManagement();
            try {
                this.storageHubManagement.deleteResourcePersistence(this.itemID, resourceID, mimetype);
            }
            catch (Exception e) {
                throw new InternalServerErrorException((Throwable)e);
            }
        }
    }

    protected String create(JsonNode jsonNode) {
        try {
            String gotResourceID;
            ObjectNode objectNode = this.validate(jsonNode);
            objectNode = this.persistStorageFile(objectNode);
            String ret = super.create(this.getAsString((JsonNode)objectNode));
            if (this.persisted && (gotResourceID = this.result.get("id").asText()) != null && gotResourceID.compareTo(this.resourceID) != 0) {
                this.resourceID = gotResourceID;
                String revisionID = this.result.get("revision_id").asText();
                this.storageHubManagement.renameFile(this.resourceID, revisionID);
            }
            return ret;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public String create(String json) {
        JsonNode jsonNode = this.getAsJsonNode(json);
        return this.create(jsonNode);
    }

    public String read() {
        return this.sendGetRequest(this.READ, this.getMapWithID(this.resourceID));
    }

    protected String update(JsonNode jsonNode) throws Exception {
        ObjectNode resourceNode = (ObjectNode)jsonNode;
        resourceNode = this.validate((JsonNode)resourceNode);
        this.getPreviousRepresentation();
        String oldURL = this.previousRepresentation.get("url").asText();
        String newURL = resourceNode.get("url").asText();
        if (oldURL.compareTo(newURL) == 0) {
            logger.trace("The URL of the resource with id {} was not changed", (Object)this.resourceID);
        } else {
            logger.trace("The URL of resource with id {} has been changed the old URL was {}, the new URL is {}", new Object[]{this.resourceID, oldURL, newURL});
            resourceNode = this.persistStorageFile(resourceNode);
        }
        String ret = super.update(this.getAsString((JsonNode)resourceNode));
        String revisionID = this.result.get("revision_id").asText();
        this.storageHubManagement.addRevisionID(this.resourceID, revisionID);
        return ret;
    }

    public String update(String json) {
        try {
            JsonNode jsonNode = this.getAsJsonNode(json);
            return this.update(jsonNode);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public String patch(String json) {
        String[] moreAllowed = new String[]{HEAD.class.getSimpleName(), GET.class.getSimpleName(), PUT.class.getSimpleName(), DELETE.class.getSimpleName()};
        throw new NotAllowedException(OPTIONS.class.getSimpleName(), moreAllowed);
    }

    public void delete(boolean purge) {
        this.delete();
    }

    public void delete() {
        try {
            this.deleteFile();
            this.sendPostRequest(this.DELETE, this.createJsonNodeWithID(this.resourceID));
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected void purge() {
        String[] moreAllowed = new String[]{HEAD.class.getSimpleName(), GET.class.getSimpleName(), PUT.class.getSimpleName(), DELETE.class.getSimpleName()};
        throw new NotAllowedException(OPTIONS.class.getSimpleName(), moreAllowed);
    }

    public JsonNode createOrUpdate(JsonNode jsonNode) {
        ObjectNode resourceNode = (ObjectNode)jsonNode;
        if (resourceNode.has("id")) {
            try {
                this.update((JsonNode)resourceNode);
            }
            catch (WebApplicationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WebApplicationException((Throwable)e);
            }
        } else {
            this.create((JsonNode)resourceNode);
        }
        return this.result;
    }

    public void deleteFile() {
        try {
            this.getPreviousRepresentation();
            URL url = new URL(this.previousRepresentation.get("url").asText());
            this.mimeType = this.previousRepresentation.get("mimetype").asText();
            this.deleteStorageResource(url, this.resourceID, this.mimeType);
        }
        catch (Exception e) {
            logger.error("Unable to delete resource {}", (Object)(this.previousRepresentation != null ? this.getAsString(this.previousRepresentation) : ""));
        }
    }

    public void rollback() {
        if (this.previousRepresentation != null) {
            try {
                this.update(this.previousRepresentation);
            }
            catch (WebApplicationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WebApplicationException((Throwable)e);
            }
        } else {
            this.delete();
        }
    }

    static {
        String context = ContextUtility.getCurrentContext();
        URI_RESOLVER_STORAGE_HUB_HOST = context.startsWith("/gcube") ? "data1-d.d4science.org" : "data.d4science.org";
        ALL_MIME_TYPES = MimeTypes.getDefaultMimeTypes();
    }
}

