/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.rest;

import com.fasterxml.jackson.databind.node.ArrayNode;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.gcube.gcat.profile.ISProfile;
import org.gcube.gcat.rest.BaseREST;

@Path(value="profiles")
public class Profile
extends BaseREST
implements org.gcube.gcat.api.interfaces.Profile<Response, Response> {
    public static final String PROFILE_NAME_PARAMETER = "PROFILE_NAME";
    @Context
    private UriInfo uriInfo;
    public static int PRETTY_PRINT_INDENT_FACTOR = 4;

    @GET
    @Produces(value={"application/json"})
    public String list() {
        this.setCalledMethod("GET /profiles");
        try {
            ISProfile isProfile = new ISProfile();
            ArrayNode arrayNode = isProfile.list();
            return isProfile.getMapper().writeValueAsString((Object)arrayNode);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @GET
    @Path(value="/{PROFILE_NAME}")
    @Produces(value={"application/xml", "application/json;charset=UTF-8"})
    public String read(@PathParam(value="PROFILE_NAME") String name, @DefaultValue(value="application/xml") @HeaderParam(value="Accept") String accept) {
        this.setCalledMethod("GET /profiles/{PROFILE_NAME}");
        try {
            ISProfile isProfile = new ISProfile();
            boolean xml = false;
            if (accept.startsWith("application/xml")) {
                xml = true;
            }
            return isProfile.read(name, xml);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @PUT
    @Path(value="/{PROFILE_NAME}")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response createOrUpdate(@PathParam(value="PROFILE_NAME") String name, String xml) {
        this.setCalledMethod("PUT /profiles/{PROFILE_NAME}");
        try {
            ISProfile isProfile = new ISProfile();
            boolean created = isProfile.createOrUpdate(name, xml);
            Response.ResponseBuilder responseBuilder = null;
            if (created) {
                responseBuilder = Response.status((Response.Status)Response.Status.CREATED);
                responseBuilder.header("Location", (Object)this.uriInfo.getAbsolutePath());
            } else {
                responseBuilder = Response.status((Response.Status)Response.Status.OK);
            }
            responseBuilder.entity((Object)xml);
            return responseBuilder.type("application/xml").build();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="/{PROFILE_NAME}")
    public Response delete(@PathParam(value="PROFILE_NAME") String name) {
        this.setCalledMethod("DELETE /profiles/{PROFILE_NAME}");
        try {
            ISProfile isProfile = new ISProfile();
            isProfile.delete(name);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public Response create(String name, String xml) {
        return this.createOrUpdate(name, xml);
    }

    public String read(String name) {
        return this.read(name, "application/xml");
    }

    public String update(String name, String xml) {
        return this.createOrUpdate(name, xml).getEntity().toString();
    }
}

