/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.persistence.ckan;

import com.fasterxml.jackson.databind.JsonNode;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.datacatalogue.ckanutillibrary.server.DataCatalogue;
import org.gcube.datacatalogue.ckanutillibrary.server.DataCatalogueFactory;
import org.gcube.datacatalogue.ckanutillibrary.server.DataCatalogueRunningCluster;
import org.gcube.datacatalogue.ckanutillibrary.server.utils.CatalogueUtilMethods;
import org.gcube.gcat.persistence.ckan.CKANOrganization;
import org.gcube.gcat.persistence.ckan.CKANUser;
import org.gcube.gcat.utils.ContextUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CKANUtility {
    private static final Logger logger = LoggerFactory.getLogger(CKANUtility.class);
    public static final String MEMBER_ROLE = "member";
    private static final String API_KEY = "apikey";

    public static DataCatalogue getCatalogue() throws Exception {
        String context = ContextUtility.getCurrentContext();
        logger.debug("Discovering ckan instance in context {}", (Object)context);
        return DataCatalogueFactory.getFactory().getUtilsPerScope(context);
    }

    public static String getSysAdminAPI() {
        try {
            DataCatalogueRunningCluster catalogueRunningInstance = new DataCatalogueRunningCluster(ContextUtility.getCurrentContext());
            return catalogueRunningInstance.getSysAdminToken();
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    protected static String getCKANUsername(String username) {
        String ckanUsername = CatalogueUtilMethods.fromUsernameToCKanUsername((String)username);
        return ckanUsername;
    }

    public static String getCKANUsername() {
        return CKANUtility.getCKANUsername((String)ContextUtility.getUsername());
    }

    public static JsonNode getCKANUser(boolean addToOrganization) {
        return CKANUtility.createCKANUser((String)CKANUtility.getCKANUsername(), (boolean)addToOrganization);
    }

    public static JsonNode getCKANUser() {
        return CKANUtility.getCKANUser((boolean)true);
    }

    protected static JsonNode createCKANUser(String ckanUsername, boolean addToOrganization) {
        ckanUsername = CKANUtility.getCKANUsername((String)ckanUsername);
        CKANUser ckanUser = new CKANUser();
        ckanUser.setApiKey(CKANUtility.getSysAdminAPI());
        try {
            ckanUser.setName(ckanUsername);
            ckanUser.read();
        }
        catch (WebApplicationException e) {
            if (e.getResponse().getStatusInfo() == Response.Status.NOT_FOUND) {
                ckanUser.setName(ckanUsername);
                ckanUser.create();
            }
            throw e;
        }
        JsonNode jsonNode = ckanUser.getJsonNodeResult();
        if (addToOrganization) {
            CKANUtility.addUserToOrganization((String)ckanUsername, (String)"member", (boolean)false);
        }
        return jsonNode;
    }

    public static void addUserToOrganization(String ckanUsername, String organizationName, String role, boolean force) {
        CKANOrganization ckanOrganization = new CKANOrganization();
        ckanOrganization.setApiKey(CKANUtility.getSysAdminAPI());
        ckanOrganization.setName(organizationName);
        ckanOrganization.addUserToOrganisation(ckanUsername, role, force);
    }

    protected static void addUserToOrganization(String ckanUsername, String role, boolean force) {
        String organizationName = CKANOrganization.getCKANOrganizationName();
        CKANUtility.addUserToOrganization((String)ckanUsername, (String)organizationName, (String)role, (boolean)force);
    }

    public static String getApiKey() throws Exception {
        String ckanUsername = CKANUtility.getCKANUsername();
        return CKANUtility.getApiKey((String)ckanUsername);
    }

    protected static String getApiKey(String ckanUsername) {
        try {
            String apiKey = CKANUtility.getCatalogue().getApiKeyFromUsername(ckanUsername);
            if (apiKey == null) {
                JsonNode jsonNode = CKANUtility.createCKANUser((String)ckanUsername, (boolean)true);
                apiKey = jsonNode.get("apikey").asText();
            }
            return apiKey;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }
}

