/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.rest;

import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Response;
import org.gcube.gcat.api.interfaces.CRUD;
import org.gcube.gcat.persistence.ckan.CKAN;
import org.gcube.gcat.rest.BaseREST;

public class REST<C extends CKAN>
extends BaseREST
implements CRUD<Response, Response> {
    protected final String COLLECTION_PARAMETER;
    protected final String ID_PARAMETER;
    protected final Class<C> reference;

    public REST(String collection_name, String id_name, Class<C> reference) {
        this.COLLECTION_PARAMETER = collection_name;
        this.ID_PARAMETER = id_name;
        this.reference = reference;
    }

    protected C getInstance() {
        try {
            CKAN ckan = (CKAN)this.reference.newInstance();
            return (C)ckan;
        }
        catch (Exception e) {
            throw new InternalServerErrorException();
        }
    }

    public String list(int limit, int offset) {
        this.setCalledMethod("GET /" + this.COLLECTION_PARAMETER);
        CKAN ckan = this.getInstance();
        return ckan.list(limit, offset);
    }

    public Response create(String json) {
        this.setCalledMethod("POST /" + this.COLLECTION_PARAMETER);
        CKAN ckan = this.getInstance();
        String ret = ckan.create(json);
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.CREATED).entity((Object)ret);
        responseBuilder = this.addLocation(responseBuilder, ckan.getName());
        return responseBuilder.type("application/json;charset=UTF-8").build();
    }

    public String read(String id) {
        this.setCalledMethod("GET /" + this.COLLECTION_PARAMETER + "/{" + this.ID_PARAMETER + "}");
        CKAN ckan = this.getInstance();
        ckan.setName(id);
        return ckan.read();
    }

    public String update(String id, String json) {
        this.setCalledMethod("PUT /" + this.COLLECTION_PARAMETER + "/{" + this.ID_PARAMETER + "}");
        CKAN ckan = this.getInstance();
        ckan.setName(id);
        return ckan.update(json);
    }

    public String patch(String id, String json) {
        this.setCalledMethod("PATCH /" + this.COLLECTION_PARAMETER + "/{" + this.ID_PARAMETER + "}");
        CKAN ckan = this.getInstance();
        ckan.setName(id);
        return ckan.patch(json);
    }

    public Response delete(String id) {
        return this.delete(id, Boolean.valueOf(false));
    }

    public Response delete(String id, Boolean purge) {
        if (purge.booleanValue()) {
            this.setCalledMethod("PURGE /" + this.COLLECTION_PARAMETER + "/{" + this.ID_PARAMETER + "}");
        } else {
            this.setCalledMethod("DELETE /" + this.COLLECTION_PARAMETER + "/{" + this.ID_PARAMETER + "}");
        }
        CKAN ckan = this.getInstance();
        ckan.setName(id);
        ckan.delete(purge.booleanValue());
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response purge(String id) {
        return this.delete(id, Boolean.valueOf(true));
    }
}

