/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.oldutils;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.trentorise.opendata.jackan.model.CkanGroup;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import org.apache.commons.lang.math.NumberUtils;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datacatalogue.ckanutillibrary.server.utils.CatalogueUtilMethods;
import org.gcube.datacatalogue.metadatadiscovery.bean.jaxb.DataType;
import org.gcube.datacatalogue.metadatadiscovery.bean.jaxb.MetadataField;
import org.gcube.datacatalogue.metadatadiscovery.bean.jaxb.MetadataFormat;
import org.gcube.datacatalogue.metadatadiscovery.bean.jaxb.MetadataGrouping;
import org.gcube.datacatalogue.metadatadiscovery.bean.jaxb.MetadataTagging;
import org.gcube.datacatalogue.metadatadiscovery.bean.jaxb.NamespaceCategory;
import org.gcube.gcat.oldutils.CustomField;
import org.gcube.gcat.oldutils.Validator;
import org.gcube.gcat.persistence.ckan.CKAN;
import org.gcube.gcat.persistence.ckan.CKANUtility;
import org.gcube.gcat.profile.MetadataUtility;
import org.geojson.GeoJsonObject;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Validator {
    private static final Logger logger = LoggerFactory.getLogger(Validator.class);
    private static final SimpleDateFormat DATE_SIMPLE = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat DATE_HOUR_MINUTES = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final int MAX_TAG_CHARS = 100;

    private static JSONObject getJSONObject(String json) {
        JSONObject jsonObject;
        JSONParser parser = new JSONParser();
        try {
            jsonObject = (JSONObject)parser.parse(json);
        }
        catch (ParseException e) {
            throw new BadRequestException(e.getMessage());
        }
        return jsonObject;
    }

    public static void validateAgainstProfile(String json) throws Exception {
        JSONObject jsonObject = Validator.getJSONObject((String)json);
        Validator.validateAgainstProfile((JSONObject)jsonObject);
    }

    public static void validateAgainstProfile(JSONObject obj) throws Exception {
        JSONArray extrasArrayOriginal = (JSONArray)obj.get((Object)"extras");
        JSONArray groupsArrayOriginal = (JSONArray)obj.get((Object)"groups");
        JSONArray tagsArrayOriginal = (JSONArray)obj.get((Object)"tags");
        if (extrasArrayOriginal == null || extrasArrayOriginal.isEmpty()) {
            throw new BadRequestException("'extras' field is missing in context where metadata profile(s) are defined!");
        }
        if (groupsArrayOriginal == null) {
            groupsArrayOriginal = new JSONArray();
        }
        if (tagsArrayOriginal == null) {
            tagsArrayOriginal = new JSONArray();
        }
        CustomField metadataTypeCF = null;
        ArrayList<CustomField> customFields = new ArrayList<CustomField>(extrasArrayOriginal.size());
        for (JSONObject object : extrasArrayOriginal) {
            CustomField cf = new CustomField(object);
            if (cf.getKey().equals("system:type")) {
                metadataTypeCF = cf;
                continue;
            }
            if (cf.getKey().equals("Item URL")) continue;
            customFields.add(cf);
        }
        if (metadataTypeCF == null) {
            throw new BadRequestException("'system:type' extra field is missing in context where metadata profile(s) are defined!");
        }
        String profileName = metadataTypeCF.getValue();
        MetadataUtility metadataUtility = MetadataUtility.getInstance();
        MetadataFormat profile = metadataUtility.getMetadataFormat(profileName);
        if (profile == null) {
            throw new BadRequestException("'system:type' extra field's value ('" + profileName + "') specified as custom field doesn't match any of the profiles defined in this context!");
        }
        JSONArray extrasArrayUpdated = null;
        List metadataFields = profile.getMetadataFields();
        if (metadataFields == null || metadataFields.isEmpty()) {
            extrasArrayUpdated = extrasArrayOriginal;
        } else {
            extrasArrayUpdated = new JSONArray();
            List categories = metadataUtility.getNamespaceCategories();
            logger.debug("Retrieved namespaces are {}", (Object)categories);
            ArrayList<String> categoriesIds = new ArrayList<String>(categories == null ? 0 : categories.size());
            if (categories == null || categories.isEmpty()) {
                logger.warn("No category defined in context {}", (Object)ScopeProvider.instance.get());
            } else {
                for (NamespaceCategory metadataCategory : categories) {
                    categoriesIds.add(metadataCategory.getId());
                }
            }
            ArrayList<CustomField> validatedCustomFields = new ArrayList<CustomField>(customFields.size());
            HashMap fieldsMandatoryLowerBoundMap = new HashMap(metadataFields.size());
            HashMap fieldsMandatoryUpperBoundMap = new HashMap(metadataFields.size());
            HashMap numberFieldsMandatorySameKeyMap = new HashMap(metadataFields.size());
            ArrayList groupsToCreateAfterValidation = new ArrayList();
            int metadataIndex = 0;
            for (MetadataField metadataField : metadataFields) {
                int categoryIdIndex = categoriesIds.indexOf(metadataField.getCategoryRef());
                logger.debug("Found index for category " + metadataField.getCategoryRef() + " " + categoryIdIndex);
                List validCFs = Validator.validateAgainstMetadataField((int)metadataIndex, (int)categoryIdIndex, customFields, (JSONArray)tagsArrayOriginal, (JSONArray)groupsArrayOriginal, (MetadataField)metadataField, (List)categories, fieldsMandatoryLowerBoundMap, fieldsMandatoryUpperBoundMap, numberFieldsMandatorySameKeyMap, groupsToCreateAfterValidation);
                validatedCustomFields.addAll(validCFs);
                ++metadataIndex;
            }
            for (Map.Entry entry : fieldsMandatoryLowerBoundMap.entrySet()) {
                int lowerBound = (Integer)entry.getValue();
                int upperBound = (Integer)fieldsMandatoryUpperBoundMap.get(entry.getKey());
                int inserted = (Integer)numberFieldsMandatorySameKeyMap.get(entry.getKey());
                logger.info("Field with key '" + (String)entry.getKey() + "' has been found " + inserted + " times and its lower bound is " + lowerBound + " and upper bound " + upperBound);
                if (inserted >= lowerBound && inserted <= upperBound) continue;
                throw new BadRequestException("Field with key '" + (String)entry.getKey() + "' is mandatory, but it's not present among the provided fields or its cardinality is not respected ([min = " + lowerBound + ", max=" + upperBound + "]).");
            }
            if (tagsArrayOriginal.isEmpty()) {
                throw new BadRequestException("Please define at least one tag for this item!");
            }
            Collections.sort(validatedCustomFields);
            logger.debug("Sorted list of custom fields is " + validatedCustomFields);
            for (CustomField cf : customFields) {
                validatedCustomFields.add(cf);
            }
            for (CustomField customField : validatedCustomFields) {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put((Object)"key", (Object)customField.getQualifiedKey());
                jsonObj.put((Object)"value", (Object)customField.getValue());
                extrasArrayUpdated.add((Object)jsonObj);
            }
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"key", (Object)metadataTypeCF.getKey());
            jSONObject.put((Object)"value", (Object)metadataTypeCF.getValue());
            extrasArrayUpdated.add((Object)jSONObject);
            for (String title : groupsToCreateAfterValidation) {
                try {
                    Validator.createGroupAsSysAdmin((String)title, (String)title, (String)"");
                }
                catch (Exception e) {
                    logger.error("Failed to create group with title " + title, (Throwable)e);
                }
            }
        }
        obj.put((Object)"tags", (Object)tagsArrayOriginal);
        obj.put((Object)"groups", (Object)groupsArrayOriginal);
        obj.put((Object)"extras", (Object)extrasArrayUpdated);
    }

    public static CkanGroup createGroupAsSysAdmin(String title, String groupName, String description) throws Exception {
        return CKAN.getCatalogue().createGroup(groupName, title, description);
    }

    private static List<CustomField> validateAgainstMetadataField(int metadataIndex, int categoryIndex, List<CustomField> customFields, JSONArray tagsArrayOriginal, JSONArray groupsArrayOriginal, MetadataField metadataField, List<NamespaceCategory> categories, Map<String, Integer> fieldsMandatoryLowerBoundMap, Map<String, Integer> fieldsMandatoryUpperBoundMap, Map<String, Integer> numberFieldsMandatorySameKeyMap, List<String> groupToCreate) throws Exception {
        ArrayList<CustomField> toReturn = new ArrayList<CustomField>();
        String metadataFieldName = metadataField.getCategoryFieldQName();
        int fieldsFoundWithThisKey = 0;
        Iterator<CustomField> iterator = customFields.iterator();
        while (iterator.hasNext()) {
            CustomField cf = iterator.next();
            if (!cf.getKey().equals(metadataFieldName)) continue;
            Validator.validate((CustomField)cf, (MetadataField)metadataField);
            ++fieldsFoundWithThisKey;
            cf.setIndexCategory(categoryIndex);
            cf.setIndexMetadataField(metadataIndex);
            Validator.checkAsGroup((CustomField)cf, (MetadataField)metadataField, (JSONArray)groupsArrayOriginal, groupToCreate);
            Validator.checkAsTag((CustomField)cf, (MetadataField)metadataField, (JSONArray)tagsArrayOriginal);
            toReturn.add(cf);
            iterator.remove();
        }
        if (metadataField.getMandatory().booleanValue()) {
            int upperBound;
            boolean hasVocabulary;
            int lowerBound = 1;
            if (fieldsMandatoryLowerBoundMap.containsKey(metadataFieldName)) {
                lowerBound = fieldsMandatoryLowerBoundMap.get(metadataFieldName) + 1;
            }
            fieldsMandatoryLowerBoundMap.put(metadataFieldName, lowerBound);
            boolean bl = hasVocabulary = metadataField.getVocabulary() != null;
            int n = hasVocabulary ? (metadataField.getVocabulary().isMultiSelection().booleanValue() ? metadataField.getVocabulary().getVocabularyFields().size() : 1) : (upperBound = 1);
            if (fieldsMandatoryUpperBoundMap.containsKey(metadataFieldName)) {
                upperBound += fieldsMandatoryUpperBoundMap.get(metadataFieldName).intValue();
            }
            fieldsMandatoryUpperBoundMap.put(metadataFieldName, upperBound);
            int countPerFields = fieldsFoundWithThisKey;
            if (numberFieldsMandatorySameKeyMap.containsKey(metadataFieldName)) {
                countPerFields += numberFieldsMandatorySameKeyMap.get(metadataFieldName).intValue();
            }
            numberFieldsMandatorySameKeyMap.put(metadataFieldName, countPerFields);
        }
        if (fieldsFoundWithThisKey == 0 && !metadataField.getMandatory().booleanValue()) {
            toReturn.add(new CustomField(metadataFieldName, "", -1, -1));
        }
        return toReturn;
    }

    private static void checkAsTag(CustomField fieldToValidate, MetadataField metadataField, JSONArray tagsArrayOriginal) {
        MetadataTagging tagging = metadataField.getTagging();
        if (tagging != null) {
            String tag = "";
            switch (1.$SwitchMap$org$gcube$datacatalogue$metadatadiscovery$bean$jaxb$TaggingGroupingValue[tagging.getTaggingValue().ordinal()]) {
                case 1: {
                    tag = metadataField.getFieldName();
                    break;
                }
                case 2: {
                    tag = fieldToValidate.getValue();
                    break;
                }
                case 3: {
                    tag = metadataField.getFieldName() + tagging.getSeparator() + fieldToValidate.getValue();
                    break;
                }
                case 4: {
                    tag = fieldToValidate.getValue() + tagging.getSeparator() + metadataField.getFieldName();
                    break;
                }
                default: {
                    return;
                }
            }
            tag = tag.substring(0, 100 > tag.length() ? tag.length() : 100);
            logger.debug("Tag is " + tag);
            JSONObject tagJSON = new JSONObject();
            tagJSON.put((Object)"name", (Object)tag);
            tagJSON.put((Object)"display_name", (Object)tag);
            tagsArrayOriginal.add((Object)tagJSON);
        }
    }

    private static void checkAsGroup(CustomField fieldToValidate, MetadataField metadataField, JSONArray groupsArrayOriginal, List<String> groupToCreate) throws Exception {
        logger.debug("Custom field is " + fieldToValidate);
        logger.debug("MetadataField field is " + metadataField);
        logger.debug("JSONArray field is " + groupsArrayOriginal);
        MetadataGrouping grouping = metadataField.getGrouping();
        if (grouping != null) {
            boolean propagateUp = grouping.getPropagateUp();
            HashSet<String> groupNames = new HashSet<String>();
            switch (1.$SwitchMap$org$gcube$datacatalogue$metadatadiscovery$bean$jaxb$TaggingGroupingValue[grouping.getGroupingValue().ordinal()]) {
                case 1: {
                    groupNames.add(metadataField.getFieldName());
                    break;
                }
                case 2: {
                    if (fieldToValidate.getValue() == null || fieldToValidate.getValue().isEmpty()) break;
                    groupNames.add(fieldToValidate.getValue());
                    break;
                }
                case 3: 
                case 4: {
                    groupNames.add(metadataField.getFieldName());
                    if (fieldToValidate.getValue() == null || fieldToValidate.getValue().isEmpty()) break;
                    groupNames.add(fieldToValidate.getValue());
                    break;
                }
                default: {
                    return;
                }
            }
            for (String title : groupNames) {
                logger.debug("Adding group to which add this item " + CatalogueUtilMethods.fromGroupTitleToName((String)title));
                JSONObject group = new JSONObject();
                group.put((Object)"name", (Object)CatalogueUtilMethods.fromGroupTitleToName((String)title));
                if (propagateUp) {
                    List parents = Validator.getGroupHierarchyNames((String)CatalogueUtilMethods.fromGroupTitleToName((String)title));
                    for (String parent : parents) {
                        JSONObject groupP = new JSONObject();
                        groupP.put((Object)"name", (Object)parent);
                        groupsArrayOriginal.add((Object)groupP);
                    }
                }
                groupsArrayOriginal.add((Object)group);
            }
            if (grouping.getCreate().booleanValue()) {
                for (String title : groupNames) {
                    groupToCreate.add(title);
                }
            }
        }
    }

    private static void validate(CustomField fieldToValidate, MetadataField metadataField) throws Exception {
        DataType dataType = metadataField.getDataType();
        String regex = metadataField.getValidator() != null ? metadataField.getValidator().getRegularExpression() : null;
        boolean hasControlledVocabulary = metadataField.getVocabulary() != null;
        String value = fieldToValidate.getValue();
        String key = fieldToValidate.getKey();
        String defaultValue = metadataField.getDefaultValue();
        fieldToValidate.setQualifiedKey(metadataField.getCategoryFieldQName());
        if (value == null || value.isEmpty()) {
            if (metadataField.getMandatory().booleanValue() || hasControlledVocabulary) {
                throw new BadRequestException("Mandatory field with name '" + key + "' doesn't have a value but it is mandatory or has a controlled vocabulary!");
            }
            if (defaultValue != null && !defaultValue.isEmpty()) {
                value = defaultValue;
                fieldToValidate.setValue(defaultValue);
            }
            return;
        }
        switch (1.$SwitchMap$org$gcube$datacatalogue$metadatadiscovery$bean$jaxb$DataType[dataType.ordinal()]) {
            case 1: 
            case 2: {
                String valueVocabulary;
                if (regex != null && !value.matches(regex)) {
                    throw new BadRequestException("Field with key '" + key + "' doesn't match the provided regular expression (" + regex + ")!");
                }
                if (!hasControlledVocabulary) break;
                List valuesVocabulary = metadataField.getVocabulary().getVocabularyFields();
                if (valuesVocabulary == null || valuesVocabulary.isEmpty()) {
                    return;
                }
                boolean match = false;
                Iterator iterator = valuesVocabulary.iterator();
                while (iterator.hasNext() && !(match = value.equals(valueVocabulary = (String)iterator.next()))) {
                }
                if (match) break;
                throw new BadRequestException("Field with key '" + key + "' has a value '" + value + "' but it doesn't match any of the vocabulary's values (" + valuesVocabulary + ")!");
            }
            case 3: {
                if (Validator.isValidDate((String)value)) break;
                throw new BadRequestException("Field with key '" + key + "' doesn't seem a valid time!");
            }
            case 4: {
                String[] timeValues = value.split("/");
                for (int i = 0; i < timeValues.length; ++i) {
                    String time = timeValues[i];
                    if (Validator.isValidDate((String)time)) continue;
                    throw new BadRequestException("Field with key '" + key + "' doesn't seem a valid time interval!");
                }
                break;
            }
            case 5: {
                String[] timeIntervals = value.split(",");
                for (int i = 0; i < timeIntervals.length; ++i) {
                    String[] timeIntervalValues = timeIntervals[i].split("/");
                    if (timeIntervalValues.length > 2) {
                        throw new BadRequestException("Field with key '" + key + "' doesn't seem a valid list of times!");
                    }
                    for (i = 0; i < timeIntervalValues.length; ++i) {
                        String time = timeIntervalValues[i];
                        if (Validator.isValidDate((String)time)) continue;
                        throw new BadRequestException("Field with key '" + key + "' doesn't seem a valid list of times!");
                    }
                }
                break;
            }
            case 6: {
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) break;
                throw new BadRequestException("Field with key '" + key + "' doesn't seem a valid boolean value!");
            }
            case 7: {
                if (NumberUtils.isNumber((String)value)) break;
                throw new BadRequestException("Field's value with key '" + key + "' is not a valid number!");
            }
            case 8: {
                try {
                    new ObjectMapper().readValue(fieldToValidate.getValue(), GeoJsonObject.class);
                    break;
                }
                catch (Exception e) {
                    throw new BadRequestException("GeoJSON field with key '" + key + "' seems not valid!");
                }
            }
        }
    }

    private static boolean isValidDate(String value) {
        try {
            DATE_HOUR_MINUTES.parse(value);
            return true;
        }
        catch (Exception e) {
            logger.debug("failed to parse date with hours and minutes, trying the other one");
            try {
                DATE_SIMPLE.parse(value);
                return true;
            }
            catch (Exception e2) {
                logger.warn("failed to parse date with simple format, returning false");
                return false;
            }
        }
    }

    public static List<String> getGroupHierarchyNames(String groupName) throws Exception {
        ArrayList<String> toReturn = new ArrayList<String>();
        String apiKey = CKANUtility.getApiKey();
        List ckanGroups = CKAN.getCatalogue().getParentGroups(groupName, apiKey);
        if (ckanGroups != null && !ckanGroups.isEmpty()) {
            for (CkanGroup ckanGroup : ckanGroups) {
                toReturn.add(ckanGroup.getName());
            }
        }
        return toReturn;
    }
}

