/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.utils;

import java.io.InputStream;
import java.util.Properties;
import javax.ws.rs.WebApplicationException;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.ClientInfo;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.gcat.utils.ContextUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApplicationMode {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationMode.class);
    private static final String PROPERTY_FILENAME = "config.properties";
    private static final String TOKEN_VARNAME = "TOKEN";
    private static final String CATALOGUE_APPLICATION_TOKEN;
    private final String originalToken;

    static {
        try {
            Properties properties = new Properties();
            InputStream input = Constants.class.getClassLoader().getResourceAsStream("config.properties");
            properties.load(input);
            CATALOGUE_APPLICATION_TOKEN = properties.getProperty("TOKEN");
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public static String getCatalogueApplicationToken() {
        return CATALOGUE_APPLICATION_TOKEN;
    }

    public ApplicationMode() {
        String applicationtoken = SecurityTokenProvider.instance.get();
        if (applicationtoken.compareTo(CATALOGUE_APPLICATION_TOKEN) != 0) {
            this.originalToken = applicationtoken;
        } else {
            logger.warn("You are already in application Mode. Operation on this instance will not have any effect.");
            this.originalToken = null;
        }
    }

    public static void setToken(String token) {
        SecurityTokenProvider.instance.set(token);
        ScopeProvider.instance.set(ContextUtility.getCurrentContext());
        try {
            AuthorizationEntry authorizationEntry = Constants.authorizationService().get(token);
            ClientInfo clientInfo = authorizationEntry.getClientInfo();
            logger.debug("User : {} - Type : {}", (Object)clientInfo.getId(), (Object)clientInfo.getType().name());
            String qualifier = authorizationEntry.getQualifier();
            Caller caller = new Caller(clientInfo, qualifier);
            AuthorizationProvider.instance.set(caller);
        }
        catch (Exception e) {
            logger.error("Unable to set Caller");
        }
    }

    public synchronized void start() {
        if (this.originalToken != null) {
            ApplicationMode.setToken((String)CATALOGUE_APPLICATION_TOKEN);
        } else {
            logger.warn("You are already in application Mode. start() does not provide any effect.");
        }
    }

    public synchronized void end() {
        if (this.originalToken != null) {
            ApplicationMode.setToken((String)this.originalToken);
        } else {
            logger.warn("You are already in application Mode. end() does not provide any effect.");
        }
    }
}

