/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.social;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.cache.Cache;
import org.gcube.datacatalogue.ckanutillibrary.server.DataCatalogue;
import org.gcube.gcat.oldutils.CachesManager;
import org.gcube.gcat.persistence.ckan.CKAN;
import org.gcube.gcat.social.GcoreEndpointReaderSNL;
import org.gcube.gcat.utils.ApplicationMode;
import org.gcube.gcat.utils.ContextUtility;
import org.gcube.gcat.utils.HTTPCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocialService
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(SocialService.class);
    public static final String ITEM_URL = "Item URL";
    protected static final String SOCIAL_SERVICE_WRITE_APPLICATION_POST_PATH = "/2/posts/write-post-app";
    protected static final String SOCIAL_SERVICE_GET_USER_INFO_PATH = "2/users/get-profile";
    protected static final String NOTIFICATION_MESSAGE = "Dear members,<br>The item '%s' has been just published by %s.<br>You can find it at: %s <br>";
    protected static final String RESULT_KEY = "result";
    protected static final String FULLNAME_IN_PROFILE_KEY = "fullname";
    protected static final String SOCIAL_POST_TEXT_KEY = "text";
    protected static final String SOCIAL_POST_ENABLE_NOTIFICATION_KEY = "enable_notification";
    protected static final String SOCIAL_POST_RESPONSE_SUCCESS_KEY = "success";
    protected static final String SOCIAL_POST_RESPONSE_MESSAGE_KEY = "message";
    protected String id;
    protected String url;
    protected String title;
    protected List<String> tags;
    protected final GcoreEndpointReaderSNL socialService = new GcoreEndpointReaderSNL();
    protected final ObjectMapper objectMapper = new ObjectMapper();

    public SocialService() throws Exception {
    }

    public SocialService(String id, String url, List<String> tags, String title) throws Exception {
        this();
        this.id = id;
        this.url = url;
        this.tags = tags;
        this.title = title;
    }

    public SocialService(String id, String url, ArrayNode arrayNode, String title) throws Exception {
        this();
        this.id = id;
        this.url = url;
        this.tags = new ArrayList();
        if (arrayNode != null && arrayNode.size() > 0) {
            int i = 0;
            while (i < arrayNode.size()) {
                String tagName = arrayNode.get(i).get("display_name").asText();
                this.tags.add(tagName);
                ++i;
            }
        }
        this.title = title;
    }

    public JsonNode getGCubeUserProfile() throws Exception {
        String username = ContextUtility.getUsername();
        return this.getGCubeUserProfile(username);
    }

    public JsonNode getGCubeUserProfile(String username) throws Exception {
        Cache userCache = CachesManager.getUserCache();
        if (userCache.containsKey((Object)username)) {
            return (JsonNode)userCache.get((Object)username);
        }
        String socialServiceBasePath = this.socialService.getServiceBasePath();
        HTTPCall httpCall = new HTTPCall(socialServiceBasePath);
        String response = httpCall.call(SOCIAL_SERVICE_GET_USER_INFO_PATH, HTTPCall.HTTPMETHOD.GET, null, "application/json");
        JsonNode jsonNode = this.objectMapper.readTree(response);
        userCache.put((Object)username, (Object)jsonNode);
        return jsonNode;
    }

    public String getFullName() throws Exception {
        if (!ContextUtility.isApplication()) {
            JsonNode jsonNode = this.getGCubeUserProfile();
            JsonNode result = jsonNode.get(RESULT_KEY);
            return result.get(FULLNAME_IN_PROFILE_KEY).asText();
        }
        return ContextUtility.getUsername();
    }

    @Override
    public void run() {
        try {
            DataCatalogue dataCatalogue = CKAN.getCatalogue();
            if (!dataCatalogue.isSocialPostEnabled()) {
                logger.info("Social Post are disabled in the context {}", (Object)ContextUtility.getCurrentContext());
                return;
            }
            logger.info("Going to send Social Post about the Item {} available at {}", (Object)this.id, (Object)this.url);
            boolean notifyUsers = dataCatalogue.isNotificationToUsersEnabled();
            this.sendSocialPost(notifyUsers);
        }
        catch (Exception e) {
            logger.error("Error while executing post creation actions", (Throwable)e);
        }
    }

    public void sendSocialPost(boolean notifyUsers) {
        try {
            String fullName = this.getFullName();
            String basePath = this.socialService.getServiceBasePath();
            if (basePath == null) {
                logger.info("Unable to write a post because there is no social networking service available");
                return;
            }
            basePath = basePath.endsWith("/") ? basePath : String.valueOf(basePath) + "/";
            StringWriter messageWriter = new StringWriter();
            messageWriter.append(String.format(NOTIFICATION_MESSAGE, this.title, fullName, this.url));
            for (String tag : this.tags) {
                tag = tag.trim();
                if ((tag = tag.replaceAll(" ", "_").replace("_+", "_")).endsWith("_")) {
                    tag = tag.substring(0, tag.length() - 1);
                }
                messageWriter.append(" #");
                messageWriter.append(tag);
            }
            String message = messageWriter.toString();
            logger.debug("The post that is going to be written is {} " + message);
            ObjectNode objectNode = this.objectMapper.createObjectNode();
            objectNode.put(SOCIAL_POST_TEXT_KEY, message);
            objectNode.put(SOCIAL_POST_ENABLE_NOTIFICATION_KEY, notifyUsers);
            HTTPCall httpCall = new HTTPCall(basePath);
            httpCall.setgCubeTargetService(false);
            httpCall.addHeader("gcube-token", ApplicationMode.getCatalogueApplicationToken());
            String response = httpCall.call(SOCIAL_SERVICE_WRITE_APPLICATION_POST_PATH, HTTPCall.HTTPMETHOD.POST, this.objectMapper.writeValueAsString((Object)objectNode), "application/json");
            JsonNode jsonNode = this.objectMapper.readTree(response);
            if (jsonNode.get(SOCIAL_POST_RESPONSE_SUCCESS_KEY).asBoolean()) {
                logger.info("Post written : {}", (Object)message);
            } else {
                logger.info("Failed to write the post {}. Reason {}", (Object)message, (Object)jsonNode.get(SOCIAL_POST_RESPONSE_MESSAGE_KEY).asText());
            }
        }
        catch (Exception e) {
            logger.error("Unable to send Social Post", (Throwable)e);
        }
    }
}

