/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.oldutils;

import com.fasterxml.jackson.databind.JsonNode;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.spi.CachingProvider;
import org.gcube.datacatalogue.metadatadiscovery.DataCalogueMetadataFormatReader;

public class CachesManager {
    public static final String PROFILES_READERS_CACHE = "profile_readers";
    public static final String PROFILES_USERS_CACHE = "profile_users";
    private static final CacheManager cacheManager;
    private static final Cache<String, DataCalogueMetadataFormatReader> readerCache;
    private static final Cache<String, JsonNode> userCache;

    static {
        CachingProvider provider = Caching.getCachingProvider();
        cacheManager = provider.getCacheManager();
        MutableConfiguration readerConfiguration = new MutableConfiguration().setTypes(String.class, DataCalogueMetadataFormatReader.class).setStoreByValue(false).setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)Duration.ONE_MINUTE));
        readerCache = cacheManager.createCache(PROFILES_READERS_CACHE, (Configuration)readerConfiguration);
        MutableConfiguration userConfiguration = new MutableConfiguration().setTypes(String.class, JsonNode.class).setStoreByValue(false).setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)Duration.ONE_MINUTE));
        userCache = cacheManager.createCache(PROFILES_USERS_CACHE, (Configuration)userConfiguration);
    }

    private CachesManager() {
    }

    public static Cache<String, DataCalogueMetadataFormatReader> getReaderCache() {
        return readerCache;
    }

    public static Cache<String, JsonNode> getUserCache() {
        return userCache;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        cacheManager.close();
    }
}

