/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.cache.Cache;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datacatalogue.metadatadiscovery.DataCalogueMetadataFormatReader;
import org.gcube.datacatalogue.metadatadiscovery.bean.MetadataProfile;
import org.gcube.datacatalogue.metadatadiscovery.reader.QueryForResourceUtil;
import org.gcube.gcat.oldutils.CachesManager;
import org.gcube.gcat.rest.BaseREST;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="profiles")
public class Profile
extends BaseREST {
    private static Logger logger = LoggerFactory.getLogger(Profile.class);
    public static final String PROFILE_NAME_PARAMETER = "PROFILE_NAME";
    public static int PRETTY_PRINT_INDENT_FACTOR = 4;

    public static DataCalogueMetadataFormatReader getDataCalogueMetadataFormatReader() throws Exception {
        DataCalogueMetadataFormatReader reader;
        String context;
        Cache readerCache = CachesManager.getReaderCache();
        if (readerCache.containsKey((Object)(context = ScopeProvider.instance.get()))) {
            reader = (DataCalogueMetadataFormatReader)readerCache.get((Object)context);
        } else {
            reader = new DataCalogueMetadataFormatReader();
            readerCache.put((Object)context, (Object)reader);
        }
        return reader;
    }

    private static void cleanCache() {
        Cache readerCache = CachesManager.getReaderCache();
        String context = ScopeProvider.instance.get();
        readerCache.remove((Object)context);
    }

    public static List<String> getProfilesNames() throws Exception {
        DataCalogueMetadataFormatReader reader = Profile.getDataCalogueMetadataFormatReader();
        ArrayList<String> toReturn = new ArrayList<String>();
        List listProfiles = reader.getListOfMetadataProfiles();
        if (listProfiles != null && !listProfiles.isEmpty()) {
            for (MetadataProfile profile : listProfiles) {
                toReturn.add(profile.getName());
            }
        }
        return toReturn;
    }

    public static String getProfileSource(String profileName) throws Exception {
        DataCalogueMetadataFormatReader reader = Profile.getDataCalogueMetadataFormatReader();
        List listProfiles = reader.getListOfMetadataProfiles();
        String xmlToReturn = null;
        if (listProfiles != null && !listProfiles.isEmpty()) {
            for (MetadataProfile profile : listProfiles) {
                if (!profile.getName().equals(profileName)) continue;
                xmlToReturn = reader.getMetadataFormatForMetadataProfile(profile).getMetadataSource();
                break;
            }
        }
        return xmlToReturn;
    }

    @GET
    @Produces(value={"application/json"})
    public String list() {
        this.setCalledMethod("GET /profiles");
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode arrayNode = mapper.createArrayNode();
        try {
            List names = Profile.getProfilesNames();
            for (String name : names) {
                arrayNode.add(name);
            }
            return mapper.writeValueAsString((Object)arrayNode);
        }
        catch (Exception e) {
            throw new InternalServerErrorException(e.getMessage());
        }
    }

    @GET
    @Path(value="/{PROFILE_NAME}")
    @Produces(value={"application/xml", "application/json;charset=UTF-8"})
    public String read(@PathParam(value="PROFILE_NAME") String name, @DefaultValue(value="application/json") @HeaderParam(value="Accept") String accept) {
        this.setCalledMethod("GET /profiles/{PROFILE_NAME}");
        try {
            String profile = Profile.getProfileSource((String)name);
            if (profile != null) {
                if (accept.startsWith("application/xml")) {
                    return profile;
                }
                JSONObject xmlJSONObj = XML.toJSONObject((String)profile);
                String jsonString = xmlJSONObj.toString(PRETTY_PRINT_INDENT_FACTOR);
                return jsonString;
            }
            throw new NotFoundException("Profile with name " + name + " not found");
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException(e.getMessage());
        }
    }

    protected GenericResource instantiateGenericResource(String name, String xml) throws Exception {
        GenericResource genericResource = new GenericResource();
        GenericResource.Profile profile = genericResource.newProfile();
        profile.type("DataCatalogueMetadata");
        profile.name(name);
        profile.description("Profile create using gCat");
        profile.newBody(xml);
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)genericResource, (Writer)stringWriter);
        logger.debug("The generated {} is\n{}", (Object)GenericResource.class.getSimpleName(), (Object)stringWriter.toString());
        return genericResource;
    }

    protected void createGenericResource(String name, String xml) throws Exception {
        GenericResource genericResource = this.instantiateGenericResource(name, xml);
        RegistryPublisher registryPublisher = RegistryPublisherFactory.create();
        genericResource = (GenericResource)registryPublisher.create((Resource)genericResource);
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)genericResource, (Writer)stringWriter);
        logger.trace("The {} with ID {} has been created \n{}", new Object[]{GenericResource.class.getSimpleName(), genericResource.id(), stringWriter.toString()});
    }

    protected GenericResource getGenericResource(String name) {
        String query = QueryForResourceUtil.getGcubeGenericQueryStringForSecondaryTypeAndName((String)name, (String)"DataCatalogueMetadata");
        QueryBox q = new QueryBox(query);
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List resources = client.submit((Query)q);
        if (resources == null || resources.size() == 0) {
            throw new InternalServerErrorException("No Resources with secondaryType 'DataCatalogueMetadata' and name '" + name + "' exists in the current context");
        }
        if (resources.size() == 1) {
            GenericResource genericResource = (GenericResource)resources.get(0);
            return genericResource;
        }
        throw new InternalServerErrorException("More than one Resource with secondaryType 'DataCatalogueMetadata' and name '" + name + "' exists in the current context");
    }

    protected void updateGenericResource(String name, String xml) {
        GenericResource genericResource = this.getGenericResource(name);
        logger.info("The {} with ID {} is going to be updated", (Object)GenericResource.class.getSimpleName(), (Object)genericResource.id());
        genericResource.profile().newBody(xml);
        RegistryPublisher registryPublisher = RegistryPublisherFactory.create();
        registryPublisher.update((Resource)genericResource);
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)genericResource, (Writer)stringWriter);
        logger.trace("The {} with ID {} has been updated to \n{}", new Object[]{GenericResource.class.getSimpleName(), genericResource.id(), stringWriter.toString()});
    }

    protected void removeGenericResource(String name) {
        GenericResource genericResource = this.getGenericResource(name);
        RegistryPublisher registryPublisher = RegistryPublisherFactory.create();
        registryPublisher.remove((Resource)genericResource);
    }

    @PUT
    @Path(value="/{PROFILE_NAME}")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String createOrUpdate(@PathParam(value="PROFILE_NAME") String name, String xml) {
        this.setCalledMethod("PUT /profiles/{PROFILE_NAME}");
        try {
            Profile.getDataCalogueMetadataFormatReader().validateProfile(xml);
            String profile = Profile.getProfileSource((String)name);
            if (profile == null) {
                this.createGenericResource(name, xml);
            } else {
                this.updateGenericResource(name, xml);
            }
            Profile.cleanCache();
            return xml;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException(e.getMessage());
        }
    }

    @DELETE
    @Path(value="/{PROFILE_NAME}")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response delete(@PathParam(value="PROFILE_NAME") String name) {
        this.setCalledMethod("DELETE /profiles/{PROFILE_NAME}");
        try {
            String profile = Profile.getProfileSource((String)name);
            if (profile == null) {
                throw new NotFoundException("Profile with name " + name + " not found");
            }
            this.removeGenericResource(name);
            Profile.cleanCache();
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException(e.getMessage());
        }
    }
}

