/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.xml.ws.WebServiceException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.gcat.client.GCatClient;

public class Item
extends GCatClient
implements org.gcube.gcat.api.interfaces.Item<String, Void> {
    public Item() throws MalformedURLException {
        super("items", new String[0]);
    }

    public Item(URL enforcedServiceURL) throws MalformedURLException {
        super(enforcedServiceURL, "items", new String[0]);
    }

    public int count() throws WebServiceException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("count", String.valueOf(true));
        String ret = this.list(queryParams);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode jsonNode = objectMapper.readTree(ret);
            return jsonNode.get("count").asInt();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public String list(int limit, int offset) throws WebApplicationException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("limit", String.valueOf(limit));
        queryParams.put("offset", String.valueOf(offset));
        return this.list(queryParams);
    }

    public String list(Map<String, String> queryParams) throws WebApplicationException {
        return super.list(queryParams, new String[0]);
    }

    public String list(int limit, int offset, String organizationName) throws WebApplicationException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("limit", String.valueOf(limit));
        queryParams.put("offset", String.valueOf(offset));
        queryParams.put("q", String.format("organization:%s", organizationName));
        return super.list(queryParams, new String[0]);
    }

    public String create(String json, boolean socialPost) throws WebApplicationException {
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("social_post", String.valueOf(socialPost));
            return super.create(json, queryParams, new String[0]);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public String create(String json) throws WebApplicationException {
        return super.create(json, new String[0]);
    }

    public String read(String name) throws WebApplicationException {
        return super.read(name);
    }

    public String update(String name, String json) throws WebApplicationException {
        return super.update(json, name);
    }

    public String patch(String name, String json) throws WebApplicationException {
        return super.patch(json, name);
    }

    public Void delete(String name) throws WebApplicationException {
        super.delete(false, name);
        return null;
    }

    public Void delete(String name, boolean purge) throws WebServiceException {
        super.delete(purge, name);
        return null;
    }

    public Void purge(String name) throws WebServiceException {
        super.delete(true, name);
        return null;
    }
}

