/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCatFeeder.tests;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.gcube.common.authorization.utils.manager.SecretManager;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.common.authorization.utils.secret.GCubeSecret;
import org.gcube.common.authorization.utils.secret.JWTSecret;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.data.publishing.gCatFeeder.model.EnvironmentConfiguration;
import org.gcube.data.publishing.gCatFeeder.tests.BaseCollectorTest;
import org.gcube.data.publishing.gCatFeeder.utils.ISUtils;
import org.junit.BeforeClass;

public class InfrastructureTests {
    private static String testContext = null;
    private static EnvironmentConfiguration env;

    protected static boolean isTestInfrastructureEnabled() {
        return testContext != null;
    }

    @BeforeClass
    public static void setTestContext() {
        if (InfrastructureTests.isTestInfrastructureEnabled()) {
            SecretManagerProvider.instance.set(new SecretManager());
            Properties props = new Properties();
            try {
                props.load(BaseCollectorTest.class.getResourceAsStream("/tokens.properties"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!props.containsKey(testContext)) {
                throw new RuntimeException("No token found for scope : " + testContext);
            }
            String toSet = props.getProperty(testContext);
            Object secret = null;
            secret = toSet.length() > 50 ? new JWTSecret(toSet) : new GCubeSecret(toSet);
            SecretManagerProvider.instance.get().addSecret((Secret)secret);
            try {
                SecretManagerProvider.instance.get().set();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to set secret for context " + testContext, e);
            }
        }
    }

    protected static EnvironmentConfiguration getEnvironmentConfiguration() {
        return env;
    }

    static {
        testContext = System.getProperty("testContext");
        System.out.println("TEST CONTEXT = " + testContext);
        env = new EnvironmentConfiguration(){

            public Map<String, String> getCurrentConfiguration() {
                if (InfrastructureTests.isTestInfrastructureEnabled()) {
                    return ISUtils.loadConfiguration();
                }
                return Collections.emptyMap();
            }
        };
    }
}

