/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCatFeeder.service.engine.impl.persistence;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gcube.data.publishing.gCatFeeder.service.engine.impl.persistence.DBField;
import org.gcube.data.publishing.gCatFeeder.service.engine.impl.persistence.DBQueryDescriptor;
import org.gcube.data.publishing.gCatFeeder.service.engine.impl.persistence.DatabaseConnectionDescriptor;
import org.gcube.data.publishing.gCatFeeder.service.engine.impl.persistence.Query;
import org.gcube.data.publishing.gCatFeeder.service.model.ExecutionDescriptor;
import org.gcube.data.publishing.gCatFeeder.service.model.ExecutionRequest;
import org.gcube.data.publishing.gCatFeeder.service.model.ExecutionStatus;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.InvalidRequest;

/*
 * Exception performing whole class analysis ignored.
 */
public class Queries {
    public static final Query GET_BY_ID = new Query("Select * from executions where id = ?", new DBField[]{(DBField)DBField.ExecutionDescriptor.fields.get("id")});
    public static final Query UPDATE = new Query("UPDATE executions SET start_time=?, end_time=?, status=?, report_url=? WHERE id=?", new DBField[]{(DBField)DBField.ExecutionDescriptor.fields.get("start_time"), (DBField)DBField.ExecutionDescriptor.fields.get("end_time"), (DBField)DBField.ExecutionDescriptor.fields.get("status"), (DBField)DBField.ExecutionDescriptor.fields.get("report_url"), (DBField)DBField.ExecutionDescriptor.fields.get("id")});
    public static final Query ACQUIRE = new Query("UPDATE executions SET status='" + ExecutionStatus.RUNNING + "', " + "start_time" + "=CURRENT_TIMESTAMP WHERE " + "id" + "=? AND " + "status" + "='" + ExecutionStatus.PENDING + "'", new DBField[]{(DBField)DBField.ExecutionDescriptor.fields.get("id")});
    public static final Query GET_ALL = new Query("SELECT * FROM executions ORDER BY end_time DESC", new DBField[0]);
    public static final Query GET_SIMILAR = new Query("SELECT * FROM executions WHERE caller_context=? AND collectors=? AND controllers=? AND (status='" + ExecutionStatus.RUNNING + "' OR " + "status" + "='" + ExecutionStatus.PENDING + "')", new DBField[]{(DBField)DBField.ExecutionDescriptor.fields.get("caller_context"), (DBField)DBField.ExecutionDescriptor.fields.get("collectors"), (DBField)DBField.ExecutionDescriptor.fields.get("controllers")});
    public static final Query INSERT_NEW = new Query("INSERT INTO executions (caller_token,caller_id,caller_context,status,collectors,controllers) VALUES (?,?,?,'" + ExecutionStatus.PENDING + "',?,?)", new DBField[]{(DBField)DBField.ExecutionDescriptor.fields.get("caller_token"), (DBField)DBField.ExecutionDescriptor.fields.get("caller_id"), (DBField)DBField.ExecutionDescriptor.fields.get("caller_context"), (DBField)DBField.ExecutionDescriptor.fields.get("collectors"), (DBField)DBField.ExecutionDescriptor.fields.get("controllers")});

    public static final String getInitDB(DatabaseConnectionDescriptor.Flavor flavor) {
        return "CREATE TABLE IF NOT EXISTS executions (id " + (flavor.equals((Object)DatabaseConnectionDescriptor.Flavor.POSTGRES) ? "BIGSERIAL" : "bigint auto_increment") + " NOT NULL," + "caller_token" + " VARCHAR NOT NULL," + "caller_id" + " VARCHAR NOT NULL," + "caller_context" + " VARCHAR NOT NULL," + "status" + " VARCHAR(40) NOT NULL," + "report_url" + " VARCHAR," + "collectors" + " text," + "controllers" + " text," + "start_time" + " timestamp with time zone," + "end_time" + " timestamp with time zone,primary key (" + "id" + "))";
    }

    public static final ExecutionDescriptor translateRow(ResultSet row) throws SQLException {
        ExecutionDescriptor toReturn = new ExecutionDescriptor();
        toReturn.setCallerContext(row.getString("caller_context"));
        toReturn.setCallerEncryptedToken(row.getString("caller_token"));
        toReturn.setCallerIdentity(row.getString("caller_id"));
        toReturn.getCatalogues().addAll(Queries.fromField((String)row.getString("controllers")));
        toReturn.getCollectors().addAll(Queries.fromField((String)row.getString("collectors")));
        Timestamp endTime = row.getTimestamp("end_time");
        if (endTime != null) {
            toReturn.setEndTime(endTime.toInstant());
        }
        toReturn.setId(Long.valueOf(row.getLong("id")));
        toReturn.setReportUrl(row.getString("report_url"));
        Timestamp startTime = row.getTimestamp("start_time");
        if (startTime != null) {
            toReturn.setStartTime(startTime.toInstant());
        }
        toReturn.setStatus(ExecutionStatus.valueOf((String)row.getString("status")));
        return toReturn;
    }

    public static final DBQueryDescriptor translateObject(ExecutionDescriptor descriptor) throws InvalidRequest {
        try {
            return new DBQueryDescriptor().add((DBField)DBField.ExecutionDescriptor.fields.get("caller_context"), (Object)descriptor.getCallerContext()).add((DBField)DBField.ExecutionDescriptor.fields.get("caller_token"), (Object)descriptor.getCallerEncryptedToken()).add((DBField)DBField.ExecutionDescriptor.fields.get("caller_id"), (Object)descriptor.getCallerIdentity()).add((DBField)DBField.ExecutionDescriptor.fields.get("controllers"), (Object)Queries.toField((Set)descriptor.getCatalogues())).add((DBField)DBField.ExecutionDescriptor.fields.get("collectors"), (Object)Queries.toField((Set)descriptor.getCollectors())).add((DBField)DBField.ExecutionDescriptor.fields.get("end_time"), descriptor.getEndTime() != null ? Timestamp.from(descriptor.getEndTime()) : null).add((DBField)DBField.ExecutionDescriptor.fields.get("id"), (Object)descriptor.getId()).add((DBField)DBField.ExecutionDescriptor.fields.get("report_url"), (Object)descriptor.getReportUrl()).add((DBField)DBField.ExecutionDescriptor.fields.get("start_time"), descriptor.getStartTime() != null ? Timestamp.from(descriptor.getStartTime()) : null).add((DBField)DBField.ExecutionDescriptor.fields.get("status"), (Object)descriptor.getStatus().toString());
        }
        catch (Throwable t) {
            throw new InvalidRequest(t);
        }
    }

    public static final DBQueryDescriptor translateObject(ExecutionRequest request) throws InvalidRequest {
        try {
            return new DBQueryDescriptor().add((DBField)DBField.ExecutionDescriptor.fields.get("caller_context"), (Object)request.getContext()).add((DBField)DBField.ExecutionDescriptor.fields.get("caller_token"), (Object)request.getEncryptedToken()).add((DBField)DBField.ExecutionDescriptor.fields.get("caller_id"), (Object)request.getCallerID()).add((DBField)DBField.ExecutionDescriptor.fields.get("controllers"), (Object)Queries.toField((Set)request.getToInvokeControllers())).add((DBField)DBField.ExecutionDescriptor.fields.get("collectors"), (Object)Queries.toField((Set)request.getToInvokeCollectors()));
        }
        catch (Throwable t) {
            throw new InvalidRequest(t);
        }
    }

    private static final Set<String> fromField(String fieldValue) {
        HashSet<String> toReturn = new HashSet<String>();
        for (String v : fieldValue.split(",")) {
            toReturn.add(v);
        }
        return toReturn;
    }

    private static final String toField(Set<String> values) {
        StringBuilder toReturn = new StringBuilder();
        if (values != null && !values.isEmpty()) {
            ArrayList<String> sorted = new ArrayList<String>(values);
            Collections.sort(sorted);
            for (String v : sorted) {
                toReturn.append(v + ",");
            }
            return toReturn.substring(0, toReturn.length() - 1);
        }
        return "";
    }
}

