/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCatFeeder.service.engine.impl;

import java.io.Serializable;
import java.time.Instant;
import java.util.Set;
import org.gcube.data.publishing.gCatFeeder.catalogues.CatalogueController;
import org.gcube.data.publishing.gCatFeeder.catalogues.CataloguePlugin;
import org.gcube.data.publishing.gCatFeeder.catalogues.model.PublishReport;
import org.gcube.data.publishing.gCatFeeder.catalogues.model.faults.CatalogueInteractionException;
import org.gcube.data.publishing.gCatFeeder.catalogues.model.faults.ControllerInstantiationFault;
import org.gcube.data.publishing.gCatFeeder.catalogues.model.faults.PublicationException;
import org.gcube.data.publishing.gCatFeeder.catalogues.model.faults.WrongObjectFormatException;
import org.gcube.data.publishing.gCatFeeder.model.CatalogueFormatData;
import org.gcube.data.publishing.gCatFeeder.model.CatalogueInstanceDescriptor;
import org.gcube.data.publishing.gCatFeeder.model.EnvironmentConfiguration;
import org.gcube.data.publishing.gCatFeeder.model.InternalConversionException;
import org.gcube.data.publishing.gCatFeeder.service.engine.CatalogueControllersManager;
import org.gcube.data.publishing.gCatFeeder.service.engine.CollectorsManager;
import org.gcube.data.publishing.gCatFeeder.service.engine.Infrastructure;
import org.gcube.data.publishing.gCatFeeder.service.engine.PersistenceManager;
import org.gcube.data.publishing.gCatFeeder.service.engine.Storage;
import org.gcube.data.publishing.gCatFeeder.service.model.ExecutionDescriptor;
import org.gcube.data.publishing.gCatFeeder.service.model.ExecutionStatus;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.CataloguePluginNotFound;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.CollectorNotFound;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.InvalidRequest;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.PersistenceError;
import org.gcube.data.publishing.gCatFeeder.service.model.reports.CatalogueReport;
import org.gcube.data.publishing.gCatFeeder.service.model.reports.CollectorReport;
import org.gcube.data.publishing.gCatFeeder.service.model.reports.ExecutionReport;
import org.gcube.data.publishing.gCatfeeder.collectors.CatalogueRetriever;
import org.gcube.data.publishing.gCatfeeder.collectors.CollectorPlugin;
import org.gcube.data.publishing.gCatfeeder.collectors.DataCollector;
import org.gcube.data.publishing.gCatfeeder.collectors.DataTransformer;
import org.gcube.data.publishing.gCatfeeder.collectors.model.faults.CatalogueInstanceNotFound;
import org.gcube.data.publishing.gCatfeeder.collectors.model.faults.CatalogueNotSupportedException;
import org.gcube.data.publishing.gCatfeeder.collectors.model.faults.CollectorFault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ExecutionTask.class);
    private ExecutionDescriptor request;
    private PersistenceManager persistence;
    private CollectorsManager collectors;
    private CatalogueControllersManager catalogues;
    private Infrastructure infrastructure;
    private Storage storage;
    private EnvironmentConfiguration environmentConfiguration;

    public ExecutionTask(ExecutionDescriptor desc) {
        this.request = desc;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.request == null ? 0 : this.request.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecutionTask other = (ExecutionTask)obj;
        return !(this.request == null ? other.request != null : !this.request.equals((Object)other.request));
    }

    public void setPersistence(PersistenceManager p) {
        this.persistence = p;
    }

    public void setCollectorPluginManager(CollectorsManager c) {
        this.collectors = c;
    }

    public void setCataloguesPluginManager(CatalogueControllersManager c) {
        this.catalogues = c;
    }

    public void setInfastructureInterface(Infrastructure infra) {
        this.infrastructure = infra;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public void setEnvironmentConfiguration(EnvironmentConfiguration environmentConfiguration) {
        this.environmentConfiguration = environmentConfiguration;
    }

    @Override
    public void run() {
        try {
            log.debug("Starting to handle {} ", (Object)this.request);
            log.debug("Setting caller token..");
            String actualToken = this.infrastructure.decrypt(this.request.getCallerEncryptedToken());
            this.infrastructure.setToken(actualToken);
            if (this.persistence.acquire(this.request.getId())) {
                try {
                    log.info("Acquired : {} ", (Object)this.request);
                    this.request = this.persistence.getById(this.request.getId());
                    ExecutionReport report = new ExecutionReport();
                    report.getGenericInformations().setStartTime(this.request.getStartTime());
                    report.setStartingScope(this.infrastructure.getCurrentContextName());
                    for (String collectorId : this.request.getCollectors()) {
                        CollectorReport collectorReport = this.handleCollector(collectorId);
                        report.getCollectorReports().add(collectorReport);
                    }
                    report.getGenericInformations().setEndTime(Instant.now());
                    String reportUrl = this.storage.storeReport(report);
                    log.info("Stored report at {} ", (Object)reportUrl);
                    this.request.setReportUrl(reportUrl);
                    this.request.setStatus(ExecutionStatus.SUCCESS);
                    this.persistence.update(this.request);
                }
                catch (InvalidRequest | PersistenceError e) {
                    log.error("Unexpected exception while dealing with persistence ", e);
                }
                catch (Throwable t) {
                    log.error("Unexpected generic exception.", t);
                    this.request.setStatus(ExecutionStatus.FAILED);
                    this.persistence.update(this.request);
                }
            } else {
                log.debug("Request [{}] is already being managed.", (Object)this.request);
            }
        }
        catch (Throwable t) {
            log.error("THREAD CANNOT HANDLE REQUESTS!!!. ", t);
            this.request.setStatus(ExecutionStatus.FAILED);
            try {
                this.persistence.update(this.request);
            }
            catch (Throwable e) {
                log.error("Unable to update execution Descriptor {} ", (Object)this.request, (Object)e);
            }
        }
    }

    private CatalogueReport handleCatalogueController(String cataloguePluginId, CollectorPlugin collectorPlugin, Set<Serializable> collectedData) {
        CatalogueReport catalogueReport = new CatalogueReport();
        catalogueReport.getGenericInformations().setStartTime(Instant.now());
        try {
            log.debug("Checking catalogue {} support ", (Object)cataloguePluginId);
            if (collectorPlugin.getSupportedCatalogueTypes().contains(cataloguePluginId)) {
                CataloguePlugin cataloguePlugin = this.catalogues.getPluginById(cataloguePluginId);
                log.debug("Looking for catalogue instance ..");
                CatalogueRetriever retriever = collectorPlugin.getRetrieverByCatalogueType(cataloguePluginId);
                CatalogueInstanceDescriptor instanceDescriptor = retriever.getInstance();
                cataloguePlugin.setEnvironmentConfiguration(this.environmentConfiguration);
                CatalogueController controller = cataloguePlugin.instantiateController(instanceDescriptor);
                controller.configure(collectorPlugin.getPublisherControllerConfiguration(cataloguePluginId));
                log.debug("Transforming Collected Data");
                DataTransformer transformer = collectorPlugin.getTransformerByCatalogueType(cataloguePluginId);
                Set transformed = transformer.transform(collectedData);
                log.trace("Going to publish {} items to {} ", (Object)transformed.size(), (Object)instanceDescriptor);
                for (CatalogueFormatData item : transformed) {
                    try {
                        catalogueReport.getPublishedRecords().add(controller.publishItem(item));
                    }
                    catch (WrongObjectFormatException e) {
                        catalogueReport.getPublishedRecords().add(new PublishReport(Boolean.valueOf(false), "Wrong format : " + e.getMessage()));
                    }
                    catch (CatalogueInteractionException e) {
                        catalogueReport.getPublishedRecords().add(new PublishReport(Boolean.valueOf(false), "Error while communicating with catalogue : " + e.getMessage()));
                    }
                    catch (PublicationException e) {
                        catalogueReport.getPublishedRecords().add(new PublishReport(Boolean.valueOf(false), "Publication error : " + e.getMessage()));
                    }
                    catch (InternalConversionException e) {
                        catalogueReport.getPublishedRecords().add(new PublishReport(Boolean.valueOf(false), "Conversion error : " + e.getMessage()));
                    }
                }
                catalogueReport.getGenericInformations().setSuccess(Boolean.valueOf(true));
                catalogueReport.getGenericInformations().setGenericMessage("Data published. See detailed log.");
            } else {
                catalogueReport.getGenericInformations().setSuccess(Boolean.valueOf(false));
                catalogueReport.getGenericInformations().setGenericMessage("Catalogue not supported by Collector Plugin.");
            }
        }
        catch (CataloguePluginNotFound e) {
            String msg = "Supported catalogue implementation not found. Catalogue id : " + cataloguePluginId;
            log.warn(msg, (Throwable)e);
            catalogueReport.getGenericInformations().setSuccess(Boolean.valueOf(false));
            catalogueReport.getGenericInformations().setGenericMessage(msg);
        }
        catch (CatalogueNotSupportedException e) {
            String msg = "Catalogue not supported by Collector Plugin.";
            log.warn(msg, (Throwable)e);
            catalogueReport.getGenericInformations().setSuccess(Boolean.valueOf(false));
            catalogueReport.getGenericInformations().setGenericMessage(msg);
        }
        catch (ControllerInstantiationFault e) {
            String msg = "Unable to contact Catalogue instance.";
            log.warn(msg, (Throwable)e);
            catalogueReport.getGenericInformations().setSuccess(Boolean.valueOf(false));
            catalogueReport.getGenericInformations().setGenericMessage(msg);
        }
        catch (CatalogueInstanceNotFound e) {
            String msg = "Unable to find Catalogue instance.";
            log.warn(msg, (Throwable)e);
            catalogueReport.getGenericInformations().setSuccess(Boolean.valueOf(false));
            catalogueReport.getGenericInformations().setGenericMessage(msg);
        }
        catalogueReport.getGenericInformations().setEndTime(Instant.now());
        return catalogueReport;
    }

    private CollectorReport handleCollector(String collectorId) {
        CollectorReport collectorReport = new CollectorReport();
        collectorReport.getGenericInformations().setStartTime(Instant.now());
        collectorReport.setSource(collectorId);
        try {
            log.info("Starting collector {} ", (Object)collectorId);
            CollectorPlugin collectorPlugin = this.collectors.getPluginById(collectorId);
            collectorPlugin.setEnvironmentConfiguration(this.environmentConfiguration);
            DataCollector collector = collectorPlugin.getCollector();
            log.info("Collecting data..");
            Set collectedData = collector.collect();
            log.debug("Collected {} items. Going to transform..", (Object)collectedData.size());
            collectorReport.setCollectedItems((long)collectedData.size());
            for (String cataloguePluginId : this.request.getCatalogues()) {
                CatalogueReport catalogueReport = this.handleCatalogueController(cataloguePluginId, collectorPlugin, collectedData);
                collectorReport.getPublisherReports().add(catalogueReport);
            }
        }
        catch (CollectorNotFound e) {
            String msg = "Requested collector implementation not found.";
            log.warn(msg, (Throwable)e);
            collectorReport.getGenericInformations().setSuccess(Boolean.valueOf(false));
            collectorReport.getGenericInformations().setGenericMessage(msg);
        }
        catch (CollectorFault e) {
            String msg = "Collector Failed. " + e.getMessage();
            log.warn(msg, (Throwable)e);
            collectorReport.getGenericInformations().setSuccess(Boolean.valueOf(false));
            collectorReport.getGenericInformations().setGenericMessage(msg);
        }
        collectorReport.getGenericInformations().setEndTime(Instant.now());
        return collectorReport;
    }
}

