/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCatFeeder.service.engine.impl.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import org.gcube.data.publishing.gCatFeeder.service.engine.ConnectionManager;
import org.gcube.data.publishing.gCatFeeder.service.engine.PersistenceManager;
import org.gcube.data.publishing.gCatFeeder.service.engine.impl.persistence.DBField;
import org.gcube.data.publishing.gCatFeeder.service.engine.impl.persistence.DBQueryDescriptor;
import org.gcube.data.publishing.gCatFeeder.service.engine.impl.persistence.Queries;
import org.gcube.data.publishing.gCatFeeder.service.model.ExecutionDescriptor;
import org.gcube.data.publishing.gCatFeeder.service.model.ExecutionRequest;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.ElementNotFound;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.InvalidRequest;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.PersistenceError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceManagerImpl
implements PersistenceManager {
    private static final Logger log = LoggerFactory.getLogger(PersistenceManagerImpl.class);
    @Inject
    ConnectionManager connections;

    public ExecutionDescriptor create(ExecutionRequest request) throws PersistenceError, InvalidRequest {
        Connection conn = null;
        try {
            log.debug("Looking for execution similar to request {} ", (Object)request);
            conn = this.connections.getConnection();
            DBQueryDescriptor queryDescriptor = Queries.translateObject((ExecutionRequest)request);
            PreparedStatement ps = Queries.GET_SIMILAR.get(conn, queryDescriptor);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                log.debug("Found similar, returning it..");
                ExecutionDescriptor executionDescriptor = Queries.translateRow((ResultSet)rs);
                return executionDescriptor;
            }
            log.debug("Inserting request ..");
            PreparedStatement psInsert = Queries.INSERT_NEW.prepare(conn, 1);
            psInsert = Queries.INSERT_NEW.fill(psInsert, queryDescriptor);
            psInsert.executeUpdate();
            ResultSet rsId = psInsert.getGeneratedKeys();
            rsId.next();
            Long generatedId = rsId.getLong("id");
            DBQueryDescriptor getQuery = new DBQueryDescriptor((DBField)DBField.ExecutionDescriptor.fields.get("id"), (Object)generatedId);
            PreparedStatement psGet = Queries.GET_BY_ID.get(conn, getQuery);
            rs = psGet.executeQuery();
            rs.next();
            ExecutionDescriptor toReturn = Queries.translateRow((ResultSet)rs);
            conn.commit();
            ExecutionDescriptor executionDescriptor = toReturn;
            return executionDescriptor;
        }
        catch (InvalidRequest e) {
            throw e;
        }
        catch (Throwable t) {
            throw new PersistenceError(t);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                throw new PersistenceError((Throwable)e);
            }
        }
    }

    public ExecutionDescriptor getById(Long id) throws PersistenceError, ElementNotFound, InvalidRequest {
        Connection conn = null;
        try {
            log.debug("Querying by ID {} ", (Object)id);
            conn = this.connections.getConnection();
            DBQueryDescriptor getQuery = new DBQueryDescriptor((DBField)DBField.ExecutionDescriptor.fields.get("id"), (Object)id);
            PreparedStatement psGet = Queries.GET_BY_ID.get(conn, getQuery);
            ResultSet rs = psGet.executeQuery();
            if (rs.next()) {
                ExecutionDescriptor executionDescriptor = Queries.translateRow((ResultSet)rs);
                return executionDescriptor;
            }
            try {
                throw new ElementNotFound("Unable to locate Element with ID " + id);
            }
            catch (InvalidRequest e) {
                throw e;
            }
            catch (Throwable t) {
                throw new PersistenceError(t);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                throw new PersistenceError((Throwable)e);
            }
        }
    }

    public Collection<ExecutionDescriptor> get(DBQueryDescriptor filter) throws PersistenceError, InvalidRequest {
        Connection conn = null;
        try {
            log.debug("Looking for execution according to filter {}", (Object)filter);
            conn = this.connections.getConnection();
            ArrayList<ExecutionDescriptor> toReturn = new ArrayList<ExecutionDescriptor>();
            PreparedStatement psGet = Queries.GET_ALL.get(conn, filter);
            ResultSet rs = psGet.executeQuery();
            while (rs.next()) {
                toReturn.add(Queries.translateRow((ResultSet)rs));
            }
            ArrayList<ExecutionDescriptor> arrayList = toReturn;
            return arrayList;
        }
        catch (InvalidRequest e) {
            throw e;
        }
        catch (Throwable t) {
            throw new PersistenceError(t);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                throw new PersistenceError((Throwable)e);
            }
        }
    }

    public boolean update(ExecutionDescriptor toUpdate) throws PersistenceError, ElementNotFound, InvalidRequest {
        Connection conn = null;
        try {
            log.debug("Updateing {} ", (Object)toUpdate);
            conn = this.connections.getConnection();
            PreparedStatement ps = Queries.UPDATE.get(conn, Queries.translateObject((ExecutionDescriptor)toUpdate));
            int result = ps.executeUpdate();
            conn.commit();
            boolean bl = result > 0;
            return bl;
        }
        catch (InvalidRequest e) {
            throw e;
        }
        catch (Throwable t) {
            throw new PersistenceError(t);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                throw new PersistenceError((Throwable)e);
            }
        }
    }

    public boolean acquire(Long id) throws PersistenceError, ElementNotFound, InvalidRequest {
        Connection conn = null;
        try {
            log.debug("Acquiring {} ", (Object)id);
            conn = this.connections.getConnection();
            PreparedStatement ps = Queries.ACQUIRE.get(conn, new DBQueryDescriptor((DBField)DBField.ExecutionDescriptor.fields.get("id"), (Object)id));
            int result = ps.executeUpdate();
            conn.commit();
            boolean bl = result > 0;
            return bl;
        }
        catch (InvalidRequest e) {
            throw e;
        }
        catch (Throwable t) {
            throw new PersistenceError(t);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                throw new PersistenceError((Throwable)e);
            }
        }
    }
}

