/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCataFeeder.catalogues.gCat;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.ws.rs.WebApplicationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.data.publishing.gCatFeeder.catalogues.CatalogueController;
import org.gcube.data.publishing.gCatFeeder.catalogues.model.PublishReport;
import org.gcube.data.publishing.gCatFeeder.catalogues.model.faults.CatalogueInteractionException;
import org.gcube.data.publishing.gCatFeeder.catalogues.model.faults.ControllerInstantiationFault;
import org.gcube.data.publishing.gCatFeeder.catalogues.model.faults.PublicationException;
import org.gcube.data.publishing.gCatFeeder.catalogues.model.faults.WrongObjectFormatException;
import org.gcube.data.publishing.gCatFeeder.model.CatalogueFormatData;
import org.gcube.data.publishing.gCatFeeder.model.CatalogueInstanceDescriptor;
import org.gcube.data.publishing.gCatFeeder.model.ControllerConfiguration;
import org.gcube.data.publishing.gCatFeeder.model.InternalConversionException;
import org.gcube.gcat.client.Item;
import org.gcube.gcat.client.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class GCatController
implements CatalogueController {
    private static final Logger log = LoggerFactory.getLogger(GCatController.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder builder;
    private static XPathFactory xPathfactory;
    private static XPath xpath;
    private static XPathExpression expr;
    private CatalogueInstanceDescriptor desc;
    private String callerToken = null;
    private ControllerConfiguration config;

    static {
        xPathfactory = XPathFactory.newInstance();
        xpath = xPathfactory.newXPath();
        try {
            builder = factory.newDocumentBuilder();
            expr = xpath.compile("string(/bookstore/book/title/@lang)");
        }
        catch (ParserConfigurationException | XPathExpressionException e) {
            throw new RuntimeException("Unable to initialize Controller");
        }
    }

    public GCatController(CatalogueInstanceDescriptor instance) throws ControllerInstantiationFault {
        this.desc = instance;
        if (this.isCustomToken()) {
            this.setCustomToken();
        }
        this.checkInstance();
        if (this.isCustomToken()) {
            this.resetToken();
        }
        this.config = new ControllerConfiguration();
        this.config.setOnClash(ControllerConfiguration.PublishingPolicy.UPDATE);
    }

    public void configure(ControllerConfiguration config) {
        this.config = config;
    }

    public PublishReport publishItem(CatalogueFormatData arg0) throws WrongObjectFormatException, CatalogueInteractionException, PublicationException, InternalConversionException {
        log.debug("Publishing {} ", (Object)arg0);
        String serialized = arg0.toCatalogueFormat();
        try {
            if (this.isCustomToken()) {
                this.setCustomToken();
            }
            log.debug("Parsing data..");
            JsonNode node = mapper.readTree(serialized);
            if (!node.hasNonNull("item")) {
                throw new WrongObjectFormatException("No \"item\" specified in serialized object");
            }
            JsonNode itemNode = node.path("item");
            if (node.hasNonNull("profile")) {
                log.debug("Publishing profile..");
                String xmlProfile = node.path("profile").asText();
                String profileName = GCatController.getProfileName(xmlProfile);
                this.createProfile(profileName, xmlProfile);
            }
            log.debug("Publishing Item..");
            String itemResp = this.createItem(itemNode.asText());
            String itemId = GCatController.getId(itemResp);
            log.debug("Pubilshed Item with ID {} ", (Object)itemId);
            if (node.hasNonNull("resources")) {
                log.debug("Pubilshing resources for {} ", (Object)itemId);
                Iterator resIterator = node.path("resources").elements();
                while (resIterator.hasNext()) {
                    JsonNode resNode = (JsonNode)resIterator.next();
                    String resourceName = resNode.path("name").asText();
                    this.createResource(itemId, resourceName, resNode.asText());
                }
            }
            PublishReport publishReport = new PublishReport(Boolean.valueOf(true), itemId);
            return publishReport;
        }
        catch (PublicationException | WrongObjectFormatException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new WrongObjectFormatException("Unable to read format ", e);
        }
        finally {
            if (this.isCustomToken()) {
                this.resetToken();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createProfile(String profileName, String xmlProfile) throws WrongObjectFormatException, PublicationException {
        Profile profile = null;
        try {
            profile = this.isForcedUrl() ? new Profile(this.getForcedUrl()) : new Profile();
            boolean exists = false;
            try {
                profile.read(profileName);
                exists = true;
            }
            catch (Throwable t) {
                exists = false;
            }
            switch (this.getOnClash()) {
                case SKIP: {
                    return null;
                }
                case FAIL: {
                    if (!exists) break;
                    throw new PublicationException("Profile " + profileName + " already existing");
                }
                case UPDATE: {
                    if (!exists) break;
                    return profile.update(profileName, xmlProfile);
                }
            }
            return profile.create(profileName, xmlProfile);
        }
        catch (WebApplicationException e) {
            GCatController.handleWebException(e);
            return null;
        }
        catch (MalformedURLException e) {
            throw new CatalogueInteractionException((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private String createResource(String itemId, String resourceName, String toCreate) throws WrongObjectFormatException, PublicationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String createItem(String toCreate) throws WrongObjectFormatException, PublicationException {
        Item item = null;
        try {
            item = this.isForcedUrl() ? new Item(this.getForcedUrl()) : new Item();
            return item.create(toCreate);
        }
        catch (WebApplicationException e) {
            GCatController.handleWebException(e);
            return null;
        }
        catch (MalformedURLException e) {
            throw new CatalogueInteractionException((Throwable)e);
        }
    }

    private ControllerConfiguration.PublishingPolicy getOnClash() {
        return this.config.getOnClash();
    }

    private boolean isForcedUrl() {
        return this.desc.getCustomToken() == null && this.desc.getUrl() != null;
    }

    private URL getForcedUrl() throws MalformedURLException {
        return new URL(this.desc.getUrl());
    }

    private boolean isCustomToken() {
        return this.desc.getCustomToken() != null;
    }

    private void setCustomToken() {
        this.callerToken = SecurityTokenProvider.instance.get();
        SecurityTokenProvider.instance.set(this.desc.getCustomToken());
    }

    private void resetToken() {
        SecurityTokenProvider.instance.set(this.callerToken);
    }

    private void checkInstance() throws ControllerInstantiationFault {
        Item item = null;
        try {
            item = this.isForcedUrl() ? new Item(this.getForcedUrl()) : new Item();
            item.list(10, 0);
        }
        catch (Throwable t) {
            String msg = String.format("Unable to contact gCat with configuration %1$s ", this.desc);
            log.error(msg, t);
            throw new ControllerInstantiationFault(msg, t);
        }
    }

    private static String getProfileName(String xmlProfile) throws WrongObjectFormatException {
        try {
            Document doc = builder.parse(new ByteArrayInputStream(xmlProfile.getBytes()));
            return (String)expr.evaluate(doc, XPathConstants.STRING);
        }
        catch (Throwable t) {
            throw new WrongObjectFormatException("Unable to parse profile. ", t);
        }
    }

    private static String getId(String publishResponse) {
        try {
            return mapper.readTree(publishResponse).path("result").path("id").asText();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("FAILED Parsing of " + publishResponse);
        }
    }

    private static String getPublishedUrl(String publishResponse) {
        try {
            Iterator iterator = mapper.readTree(publishResponse).path("result").path("extras").elements();
            while (iterator.hasNext()) {
                JsonNode node = (JsonNode)iterator.next();
                if (!node.path("key").asText().equals("Item URL")) continue;
                return node.path("value").asText();
            }
            return "N/A";
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("FAILED Parsing of " + publishResponse);
        }
    }

    private static void handleWebException(WebApplicationException e) throws WrongObjectFormatException, PublicationException {
        log.debug("Received Web Exception {} ", (Throwable)e);
        String msg = null;
        try {
            e.getResponse().readEntity(String.class);
        }
        catch (IllegalStateException e1) {
            msg = "Status : " + e.getResponse().getStatus();
        }
        switch (e.getResponse().getStatus()) {
            case 400: {
                throw new WrongObjectFormatException("BAD Request : " + msg, (Throwable)e);
            }
            case 401: {
                throw new CatalogueInteractionException("Unauthorized : " + msg, (Throwable)e);
            }
            case 404: {
                throw new CatalogueInteractionException("NOT FOUND : " + msg, (Throwable)e);
            }
            case 405: {
                throw new CatalogueInteractionException("Method Not Allowed : " + msg, (Throwable)e);
            }
            case 409: {
                throw new CatalogueInteractionException("Conflict : " + msg, (Throwable)e);
            }
            case 500: {
                throw new CatalogueInteractionException("Remote Error : " + msg, (Throwable)e);
            }
        }
        throw new PublicationException("Unexpected error code : " + msg, (Throwable)e);
    }
}

