/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.fs;

import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import jnr.ffi.Pointer;
import jnr.ffi.types.mode_t;
import jnr.ffi.types.off_t;
import jnr.ffi.types.size_t;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.gcube.common.security.AuthorizedTasks;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.common.security.secrets.UmaTokenSecret;
import org.gcube.common.storagehub.client.dsl.ContainerType;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.ItemContainer;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.data.access.storagehub.fs.FSInputStream;
import org.gcube.data.access.storagehub.fs.FileDownload;
import org.gcube.data.access.storagehub.fs.FileUpload;
import org.gcube.data.access.storagehub.fs.PathUtils;
import org.gcube.data.access.storagehub.fs.SHFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.serce.jnrfuse.ErrorCodes;
import ru.serce.jnrfuse.FuseFillDir;
import ru.serce.jnrfuse.FuseStubFS;
import ru.serce.jnrfuse.struct.FileStat;
import ru.serce.jnrfuse.struct.FuseFileInfo;
import ru.serce.jnrfuse.struct.Timespec;

public class StorageHubFS
extends FuseStubFS {
    public static Logger logger = LoggerFactory.getLogger(StorageHubFS.class);
    StorageHubClient client;
    Secret secret;
    HashMap<String, SHFile> tempFiles = new HashMap();
    protected static final String VREFOLDERS_NAME = "VREFolders";
    Cache<String, ItemContainer<Item>> cache;
    PathUtils pathUtils;
    private FolderContainer rootDirectory;
    final long creationTime = System.currentTimeMillis();

    public StorageHubFS(String token) {
        this.secret = new UmaTokenSecret(token);
        logger.debug("using token {}", (Object)token);
        SecretManagerProvider.set(this.secret);
        this.client = new StorageHubClient();
        this.rootDirectory = this.client.getWSRoot();
        this.cache = new Cache2kBuilder<String, ItemContainer<Item>>(){}.expireAfterWrite(30L, TimeUnit.SECONDS).resilienceDuration(30L, TimeUnit.SECONDS).build();
        this.pathUtils = new PathUtils(this.cache, this.rootDirectory, this.client);
    }

    @Override
    public synchronized int write(String path, Pointer buf, long size, long offset, FuseFileInfo fi) {
        SecretManagerProvider.set(this.secret);
        logger.trace("{}) calling write {} - {} ", Thread.currentThread().getName(), size, offset);
        SHFile file = this.tempFiles.get(path);
        return file.write(buf, size, offset);
    }

    @Override
    public int flush(String path, FuseFileInfo fi) {
        logger.trace("called flush for {} ", (Object)path);
        SHFile file = this.tempFiles.get(path);
        file.flush();
        if (!(file instanceof FileUpload)) {
            logger.trace("file have been removed? {}", (Object)(this.tempFiles.remove(path) != null ? 1 : 0));
            this.cache.remove(this.pathUtils.getParentPath(path));
            this.cache.remove(path);
        }
        return 0;
    }

    @Override
    public synchronized int create(String path, @mode_t long mode, FuseFileInfo fi) {
        SecretManagerProvider.set(this.secret);
        logger.trace(Thread.currentThread().getName() + " ) calling create " + path);
        if (this.pathUtils.getPath(path) != null) {
            return -ErrorCodes.EEXIST();
        }
        return this.uploadFile(path);
    }

    private int uploadFile(final String path) {
        ItemContainer parentContainer;
        if (path.substring(1).contains("/")) {
            String parentPath = Paths.get(path, new String[0]).getParent().toString();
            parentContainer = this.pathUtils.getPath(parentPath);
        } else {
            parentContainer = this.rootDirectory;
        }
        try {
            if (!parentContainer.canWrite()) {
                return -ErrorCodes.EACCES();
            }
        }
        catch (Exception e) {
            return -ErrorCodes.EIO();
        }
        final FSInputStream stream = new FSInputStream();
        FileUpload fileUpload = new FileUpload(stream);
        this.tempFiles.put(path, fileUpload);
        new Thread(AuthorizedTasks.bind(new Runnable(){

            @Override
            public void run() {
                try {
                    ((FolderContainer)parentContainer).uploadFile(stream, StorageHubFS.this.pathUtils.getLastComponent(path), "");
                }
                catch (Throwable t) {
                    StorageHubFS.this.tempFiles.get(path).flush();
                }
                logger.trace("file have been removed? {}", (Object)(StorageHubFS.this.tempFiles.remove(path) != null ? 1 : 0));
                StorageHubFS.this.cache.remove(StorageHubFS.this.pathUtils.getParentPath(path));
                StorageHubFS.this.cache.remove(path);
            }
        })).start();
        return 0;
    }

    @Override
    public int getattr(String path, FileStat stat) {
        SecretManagerProvider.set(this.secret);
        logger.trace(Thread.currentThread().getName() + " ) calling getattr " + path);
        if (Objects.equals(path, "/") || path.contains("Trash") || path.equals("/VREFolders")) {
            stat.st_mode.set(16877);
            stat.st_size.set(4096);
            stat.st_mtim.tv_sec.set(this.creationTime / 1000L);
            stat.st_mtim.tv_nsec.set(this.creationTime);
            stat.st_ctim.tv_sec.set(this.creationTime / 1000L);
            stat.st_ctim.tv_nsec.set(this.creationTime);
            stat.st_nlink.set(2);
        } else {
            if (this.tempFiles.containsKey(path)) {
                return this.tempFiles.get(path).getAttr(stat);
            }
            logger.trace("trying items");
            ItemContainer<? extends Item> container = this.pathUtils.getPath(path);
            logger.trace("item for path " + path + " is null ? " + (container == null));
            if (container == null) {
                return -ErrorCodes.ENOENT();
            }
            try {
                this.getAttrSHItem(container, stat);
            }
            catch (Throwable e) {
                logger.error("error gettign attributes ", e);
                return -ErrorCodes.ENOENT();
            }
        }
        stat.st_uid.set(this.getContext().uid.get());
        return 0;
    }

    private void getAttrSHItem(ItemContainer<? extends Item> container, FileStat stat) throws IllegalArgumentException {
        if (container.getType() == ContainerType.FILE) {
            AbstractFileItem fileItem = (AbstractFileItem)container.get();
            stat.st_size.set(fileItem.getContent().getSize());
            this.setCommonAttributes(fileItem, stat, 32768);
            logger.trace("fileContent is " + fileItem.getContent().getSize());
        } else if (container.getType() == ContainerType.FOLDER) {
            FolderItem folderItem = (FolderItem)container.get();
            stat.st_size.set(4096);
            this.setCommonAttributes(folderItem, stat, 16384);
        } else {
            throw new IllegalArgumentException("container type not valid");
        }
    }

    private void setCommonAttributes(Item item, FileStat stat, int type) {
        stat.st_mode.set(type | 0x1FF);
        stat.st_mtim.tv_sec.set(item.getLastModificationTime().toInstant().getEpochSecond());
        stat.st_mtim.tv_nsec.set(item.getLastModificationTime().toInstant().getNano());
        stat.st_ctim.tv_sec.set(item.getCreationTime().toInstant().getEpochSecond());
        stat.st_ctim.tv_nsec.set(item.getCreationTime().toInstant().getNano());
    }

    @Override
    public int mkdir(String path, @mode_t long mode) {
        ItemContainer parentContainer;
        SecretManagerProvider.set(this.secret);
        logger.trace(Thread.currentThread().getName() + " ) calling mkdir");
        if (path.substring(1).contains("/")) {
            String parentPath = Paths.get(path, new String[0]).getParent().toString();
            parentContainer = this.pathUtils.getPath(parentPath);
        } else {
            parentContainer = this.rootDirectory;
        }
        FolderContainer parentDir = parentContainer;
        String dirName = this.pathUtils.getLastComponent(path);
        try {
            parentDir.newFolder(dirName, dirName);
            return 0;
        }
        catch (Exception e) {
            logger.error("error in mkdir", e);
            return -ErrorCodes.ENOENT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(String path, Pointer buf, @size_t long size, @off_t long offset, FuseFileInfo fi) {
        HashMap<String, SHFile> hashMap;
        SecretManagerProvider.set(this.secret);
        logger.trace("!!! read called in path {} with size {} and offset {} and pointer address {}", path, size, offset, buf.address());
        SHFile fileDownload = null;
        boolean loop = false;
        do {
            hashMap = this.tempFiles;
            synchronized (hashMap) {
                if (this.tempFiles.containsKey(path) && this.tempFiles.get(path) instanceof FileUpload) {
                    loop = true;
                    logger.trace("upload not finished yet for {}", (Object)path);
                } else {
                    loop = false;
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (loop);
        hashMap = this.tempFiles;
        synchronized (hashMap) {
            if (this.tempFiles.containsKey(path) && this.tempFiles.get(path) instanceof FileDownload) {
                logger.trace("path {} found in tmpFiles", (Object)path);
                fileDownload = this.tempFiles.get(path);
            } else {
                ItemContainer<? extends Item> item = this.pathUtils.getPath(path);
                if (item == null) {
                    return -ErrorCodes.ENOENT();
                }
                if (item.getType() != ContainerType.FILE) {
                    return -ErrorCodes.EISDIR();
                }
                try {
                    fileDownload = new FileDownload((FileContainer)item);
                }
                catch (Exception e) {
                    logger.error("error reading remote file", e);
                    return -ErrorCodes.ENOENT();
                }
                this.tempFiles.put(path, fileDownload);
            }
        }
        int toReturn = fileDownload.read(buf, size, offset);
        logger.trace("!!! read ---- returning {}", (Object)toReturn);
        return toReturn;
    }

    @Override
    public int readdir(String path, Pointer buf, FuseFillDir filter, @off_t long offset, FuseFileInfo fi) {
        List<ItemContainer<? extends Item>> containers;
        logger.trace("readdir called");
        SecretManagerProvider.set(this.secret);
        logger.trace(Thread.currentThread().getName() + " ) calling readdir " + (String)path);
        if (((String)path).contains(".Trash")) {
            return 0;
        }
        if (((String)path).equals("/VREFolders")) {
            try {
                containers = this.client.getVREFolders().getContainers();
            }
            catch (StorageHubException she) {
                logger.error("error reading dir", she);
                return -ErrorCodes.EACCES();
            }
        }
        ItemContainer<? extends Item> container = this.pathUtils.getPath((String)path);
        if (container == null) {
            return -ErrorCodes.ENOENT();
        }
        if (container.getType() != ContainerType.FOLDER) {
            return -ErrorCodes.ENOTDIR();
        }
        try {
            logger.trace("reading folder " + (String)path);
            containers = ((FolderContainer)container).list().withContent().getContainers();
            logger.trace("folder read " + (String)path);
        }
        catch (UserNotAuthorizedException userNotAuthorizedException) {
            logger.error("folder error ", userNotAuthorizedException);
            return -ErrorCodes.EACCES();
        }
        catch (StorageHubException storageHubException) {
            logger.error("folder error ", storageHubException);
            return -ErrorCodes.EREMOTEIO();
        }
        catch (Throwable throwable) {
            logger.error("folder error ", throwable);
            throw new RuntimeException(throwable);
        }
        filter.apply(buf, ".", null, 0L);
        filter.apply(buf, "..", null, 0L);
        for (ItemContainer<? extends Item> itemContainer : containers) {
            try {
                Item it = itemContainer.get();
                String name = it instanceof SharedFolder && ((SharedFolder)it).isVreFolder() ? ((SharedFolder)it).getDisplayName() : it.getTitle();
                filter.apply(buf, name, null, 0L);
                if (((String)path).charAt(((String)path).length() - 1) != '/') {
                    path = (String)path + "/";
                }
                this.cache.put((String)path + name, itemContainer);
            }
            catch (Exception e) {
                logger.error("error reading children ", e);
            }
        }
        logger.trace("tempFiles.entrySet() is empty ? {}", (Object)this.tempFiles.entrySet().isEmpty());
        for (Map.Entry entry : this.tempFiles.entrySet()) {
            logger.trace("entry in temp map {}", entry.getKey());
            if (!(entry.getValue() instanceof FileUpload) || !this.pathUtils.getParentPath((String)entry.getKey()).equals(path)) continue;
            filter.apply(buf, this.pathUtils.getLastComponent((String)entry.getKey()), null, 0L);
            logger.trace("last temp entry added {}", entry.getKey());
        }
        if (((String)path).equals("/")) {
            filter.apply(buf, VREFOLDERS_NAME, null, 0L);
        }
        return 0;
    }

    @Override
    public int rename(String path, String newName) {
        SecretManagerProvider.set(this.secret);
        ItemContainer<? extends Item> folder = this.pathUtils.getPath(path);
        if (folder == null) {
            return -ErrorCodes.ENOENT();
        }
        ItemContainer<? extends Item> newParent = this.pathUtils.getPath(this.pathUtils.getParentPath(newName));
        if (newParent == null) {
            return -ErrorCodes.ENOENT();
        }
        if (newParent.getType() != ContainerType.FOLDER) {
            return -ErrorCodes.ENOTDIR();
        }
        try {
            if (newParent.getId() != folder.get().getParentId()) {
                folder.move((FolderContainer)newParent);
            }
            if (!this.pathUtils.getLastComponent(newName).equals(this.pathUtils.getLastComponent(path))) {
                folder.rename(this.pathUtils.getLastComponent(newName));
            }
            this.cache.remove(path);
        }
        catch (UserNotAuthorizedException una) {
            return -ErrorCodes.EACCES();
        }
        catch (StorageHubException she) {
            return -ErrorCodes.EREMOTEIO();
        }
        return 0;
    }

    @Override
    public int rmdir(String path) {
        if (path.equals("/VREFolders")) {
            return -ErrorCodes.EACCES();
        }
        SecretManagerProvider.set(this.secret);
        ItemContainer<? extends Item> folder = this.pathUtils.getPath(path);
        if (folder == null) {
            return -ErrorCodes.ENOENT();
        }
        if (folder.getType() != ContainerType.FOLDER) {
            return -ErrorCodes.ENOTDIR();
        }
        SecretManagerProvider.set(this.secret);
        try {
            this.checkSpecialFolderRemove(path);
            if (folder.get() instanceof SharedFolder && ((SharedFolder)folder.get()).isVreFolder()) {
                return -ErrorCodes.EACCES();
            }
            folder.delete();
            this.cache.remove(path);
        }
        catch (UserNotAuthorizedException una) {
            return -ErrorCodes.EACCES();
        }
        catch (StorageHubException she) {
            return -ErrorCodes.EREMOTEIO();
        }
        return 0;
    }

    public void checkSpecialFolderRemove(String path) throws UserNotAuthorizedException {
        if (path.equals(String.format("/%s", VREFOLDERS_NAME))) {
            throw new UserNotAuthorizedException("VREFolders cannot be deleted");
        }
    }

    @Override
    public int unlink(String path) {
        SecretManagerProvider.set(this.secret);
        ItemContainer<? extends Item> file = this.pathUtils.getPath(path);
        if (file == null) {
            return -ErrorCodes.ENOENT();
        }
        if (file.getType() != ContainerType.FILE) {
            return -ErrorCodes.EISDIR();
        }
        SecretManagerProvider.set(this.secret);
        try {
            file.delete();
            this.cache.remove(path);
        }
        catch (UserNotAuthorizedException una) {
            return -ErrorCodes.EACCES();
        }
        catch (StorageHubException she) {
            return -ErrorCodes.EREMOTEIO();
        }
        return 0;
    }

    @Override
    public int readlink(String path, Pointer buf, @size_t long size) {
        logger.info("readlink called {}", (Object)path);
        return 0;
    }

    @Override
    public int open(String path, FuseFileInfo fi) {
        logger.info("open called {} {}", (Object)path, (Object)fi.fh.getMemory().address());
        return 0;
    }

    @Override
    public int release(String path, FuseFileInfo fi) {
        logger.info("release called {} {}", (Object)path, (Object)fi.fh.getMemory().address());
        return 0;
    }

    @Override
    public int truncate(String path, long size) {
        logger.info("truncate called {} ", (Object)path);
        SecretManagerProvider.set(this.secret);
        this.cache.remove(path);
        this.uploadFile(path);
        return 0;
    }

    @Override
    public int access(String path, int mask) {
        logger.trace("access function called " + path + " " + mask);
        return 0;
    }

    @Override
    public int utimens(String path, Timespec[] timespec) {
        logger.trace("utimens called " + path);
        return 0;
    }
}

