/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.jcache.provider.event;

import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import org.cache2k.jcache.provider.event.EntryEvent;

abstract class Listener<K, V> {
    CacheEntryListenerConfiguration<K, V> config;
    CacheEntryEventFilter<K, V> filter;
    CacheEntryListener<K, V> entryListener;

    public Listener(CacheEntryListenerConfiguration<K, V> _config, CacheEntryEventFilter<K, V> _filter, CacheEntryListener<K, V> _entryListener) {
        this.config = _config;
        this.filter = _filter;
        this.entryListener = _entryListener;
    }

    public abstract EventType getEventType();

    public abstract void fire(EntryEvent<K, V> var1);

    static class Expired<K, V>
    extends Listener<K, V> {
        CacheEntryExpiredListener<K, V> listener;

        public Expired(CacheEntryListenerConfiguration<K, V> _config, CacheEntryEventFilter<K, V> _filter, CacheEntryExpiredListener<K, V> _listener) {
            super(_config, _filter, _listener);
            this.listener = _listener;
        }

        @Override
        public EventType getEventType() {
            return EventType.EXPIRED;
        }

        @Override
        public void fire(EntryEvent<K, V> e) {
            if (this.filter != null && !this.filter.evaluate(e)) {
                return;
            }
            this.listener.onExpired(e);
        }
    }

    static class Removed<K, V>
    extends Listener<K, V> {
        CacheEntryRemovedListener<K, V> listener;

        public Removed(CacheEntryListenerConfiguration<K, V> _config, CacheEntryEventFilter<K, V> _filter, CacheEntryRemovedListener<K, V> _listener) {
            super(_config, _filter, _listener);
            this.listener = _listener;
        }

        @Override
        public EventType getEventType() {
            return EventType.REMOVED;
        }

        @Override
        public void fire(EntryEvent<K, V> e) {
            if (this.filter != null && !this.filter.evaluate(e)) {
                return;
            }
            this.listener.onRemoved(e);
        }
    }

    static class Updated<K, V>
    extends Listener<K, V> {
        CacheEntryUpdatedListener<K, V> listener;

        public Updated(CacheEntryListenerConfiguration<K, V> _config, CacheEntryEventFilter<K, V> _filter, CacheEntryUpdatedListener<K, V> _listener) {
            super(_config, _filter, _listener);
            this.listener = _listener;
        }

        @Override
        public EventType getEventType() {
            return EventType.UPDATED;
        }

        @Override
        public void fire(EntryEvent<K, V> e) {
            if (this.filter != null && !this.filter.evaluate(e)) {
                return;
            }
            this.listener.onUpdated(e);
        }
    }

    static class Created<K, V>
    extends Listener<K, V> {
        CacheEntryCreatedListener<K, V> listener;

        public Created(CacheEntryListenerConfiguration<K, V> _config, CacheEntryEventFilter<K, V> _filter, CacheEntryCreatedListener<K, V> _listener) {
            super(_config, _filter, _listener);
            this.listener = _listener;
        }

        @Override
        public EventType getEventType() {
            return EventType.CREATED;
        }

        @Override
        public void fire(EntryEvent<K, V> e) {
            if (this.filter != null && !this.filter.evaluate(e)) {
                return;
            }
            this.listener.onCreated(e);
        }
    }
}

