/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.security.Key;
import org.gcube.io.jsonwebtoken.Claims;
import org.gcube.io.jsonwebtoken.JwsHeader;
import org.gcube.io.jsonwebtoken.Locator;
import org.gcube.io.jsonwebtoken.SigningKeyResolver;
import org.gcube.io.jsonwebtoken.lang.Assert;

public class LocatingKeyResolver
implements SigningKeyResolver {
    private final Locator<? extends Key> locator;

    public LocatingKeyResolver(Locator<? extends Key> locator) {
        this.locator = Assert.notNull(locator, "Locator cannot be null.");
    }

    @Override
    public Key resolveSigningKey(JwsHeader header, Claims claims) {
        return this.locator.locate(header);
    }

    @Override
    public Key resolveSigningKey(JwsHeader header, byte[] content) {
        return this.locator.locate(header);
    }
}

