/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl;

import java.io.IOException;
import java.io.Reader;
import org.gcube.io.jsonwebtoken.MalformedJwtException;
import org.gcube.io.jsonwebtoken.impl.DefaultTokenizedJwe;
import org.gcube.io.jsonwebtoken.impl.DefaultTokenizedJwt;
import org.gcube.io.jsonwebtoken.impl.TokenizedJwt;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Strings;

public class JwtTokenizer {
    static final char DELIMITER = '.';
    private static final String DELIM_ERR_MSG_PREFIX = "Invalid compact JWT string: Compact JWSs must contain exactly 2 period characters, and compact JWEs must contain exactly 4.  Found: ";

    private static int read(Reader r, char[] buf) {
        try {
            return r.read(buf);
        }
        catch (IOException e) {
            String msg = "Unable to read compact JWT: " + e.getMessage();
            throw new MalformedJwtException(msg, e);
        }
    }

    public <T extends TokenizedJwt> T tokenize(Reader reader) {
        Assert.notNull(reader, "Reader argument cannot be null.");
        String protectedHeader = "";
        String body = "";
        String encryptedKey = "";
        String iv = "";
        String digest = "";
        int delimiterCount = 0;
        char[] buf = new char[4096];
        int len = 0;
        StringBuilder sb = new StringBuilder(4096);
        while (len != -1) {
            len = JwtTokenizer.read(reader, buf);
            for (int i = 0; i < len; ++i) {
                char c = buf[i];
                if (Character.isWhitespace(c)) {
                    String msg = "Compact JWT strings may not contain whitespace.";
                    throw new MalformedJwtException(msg);
                }
                if (c == '.') {
                    CharSequence seq = Strings.clean(sb);
                    String token = seq != null ? seq.toString() : "";
                    switch (delimiterCount) {
                        case 0: {
                            protectedHeader = token;
                            break;
                        }
                        case 1: {
                            body = token;
                            encryptedKey = token;
                            break;
                        }
                        case 2: {
                            body = "";
                            iv = token;
                            break;
                        }
                        case 3: {
                            body = token;
                        }
                    }
                    ++delimiterCount;
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
            }
        }
        if (delimiterCount != 2 && delimiterCount != 4) {
            String msg = DELIM_ERR_MSG_PREFIX + delimiterCount;
            throw new MalformedJwtException(msg);
        }
        if (sb.length() > 0) {
            digest = sb.toString();
        }
        if (delimiterCount == 2) {
            return (T)new DefaultTokenizedJwt(protectedHeader, body, digest);
        }
        return (T)new DefaultTokenizedJwe(protectedHeader, body, digest, encryptedKey, iv);
    }
}

