/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.builders;

import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import jakarta.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import java.net.URI;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddressingUtils {
    public static final String keyElement = "ResourceKey";
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static final String scheme_prefix = "http";
    private static final String keyElementPrefix = "key";

    public static W3CEndpointReference address(String contextPath, String service, String host, int port) throws IllegalArgumentException {
        return AddressingUtils.address(scheme_prefix, contextPath, service, host, port);
    }

    public static W3CEndpointReference address(String protocol, String contextPath, String service, String host, int port) throws IllegalArgumentException {
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        builder.address(AddressingUtils.join(protocol, contextPath, service, host, port));
        return builder.build();
    }

    public static W3CEndpointReference address(String contextPath, String service, URL address) throws IllegalArgumentException {
        return AddressingUtils.address(address.getProtocol(), contextPath, service, address.getHost(), AddressingUtils.portFrom(address));
    }

    public static W3CEndpointReference address(String protocol, String contextPath, String service, URL address) throws IllegalArgumentException {
        return AddressingUtils.address(address.getProtocol(), contextPath, service, address.getHost(), AddressingUtils.portFrom(address));
    }

    public static W3CEndpointReference address(String contextPath, String service, URI address) throws IllegalArgumentException {
        return AddressingUtils.address(address.getScheme(), contextPath, service, address.getHost(), AddressingUtils.portFrom(address));
    }

    public static W3CEndpointReference address(String contextPath, String service, String namespace, String key, String host, int port) throws IllegalArgumentException {
        return AddressingUtils.address(scheme_prefix, contextPath, service, namespace, key, host, port);
    }

    public static W3CEndpointReference address(String protocol, String contextPath, String service, String namespace, String key, String host, int port) throws IllegalArgumentException {
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        builder.address(AddressingUtils.join(protocol, contextPath, service, host, port));
        builder.referenceParameter(AddressingUtils.key(namespace, key));
        return builder.build();
    }

    public static W3CEndpointReference address(String contextPath, String service, String namespace, String key, URL address) throws IllegalArgumentException {
        return AddressingUtils.address(contextPath, service, namespace, key, address.getHost(), AddressingUtils.portFrom(address));
    }

    public static W3CEndpointReference address(String contextPath, String service, String namespace, String key, URI address) throws IllegalArgumentException {
        return AddressingUtils.address(contextPath, service, namespace, key, address.getHost(), AddressingUtils.portFrom(address));
    }

    private static String join(String protocol, String path, String service, String host, int port) {
        if (host.startsWith(protocol)) {
            host = host.substring(protocol.length(), host.length());
        }
        String address = protocol + "://" + host + ":" + port + path + service;
        return address;
    }

    public static Element key(String namespace, String value) {
        try {
            Document document = factory.newDocumentBuilder().newDocument();
            Element key = document.createElementNS(namespace, "key:ResourceKey");
            key.setAttribute("xmlns:key", namespace);
            key.appendChild(document.createTextNode(value));
            return key;
        }
        catch (Exception e) {
            throw new RuntimeException("programming error in AddressingUtils#key");
        }
    }

    private static int portFrom(URI address) {
        return address.getPort() != -1 ? address.getPort() : 80;
    }

    private static int portFrom(URL address) {
        return AddressingUtils.portFrom(URI.create(address.toExternalForm()));
    }

    static {
        factory.setNamespaceAware(true);
    }
}

