/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.math.BigInteger;
import java.security.spec.RSAOtherPrimeInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.gcube.io.jsonwebtoken.impl.lang.Converter;
import org.gcube.io.jsonwebtoken.impl.lang.Parameter;
import org.gcube.io.jsonwebtoken.impl.lang.Parameters;
import org.gcube.io.jsonwebtoken.impl.lang.RequiredParameterReader;
import org.gcube.io.jsonwebtoken.impl.security.DefaultJwkContext;
import org.gcube.io.jsonwebtoken.lang.Collections;
import org.gcube.io.jsonwebtoken.security.MalformedKeyException;

class RSAOtherPrimeInfoConverter
implements Converter<RSAOtherPrimeInfo, Object> {
    static final RSAOtherPrimeInfoConverter INSTANCE = new RSAOtherPrimeInfoConverter();
    static final Parameter<BigInteger> PRIME_FACTOR = Parameters.secretBigInt("r", "Prime Factor");
    static final Parameter<BigInteger> FACTOR_CRT_EXPONENT = Parameters.secretBigInt("d", "Factor CRT Exponent");
    static final Parameter<BigInteger> FACTOR_CRT_COEFFICIENT = Parameters.secretBigInt("t", "Factor CRT Coefficient");
    static final Set<Parameter<?>> PARAMS = Collections.setOf(PRIME_FACTOR, FACTOR_CRT_EXPONENT, FACTOR_CRT_COEFFICIENT);

    RSAOtherPrimeInfoConverter() {
    }

    @Override
    public Object applyTo(RSAOtherPrimeInfo info) {
        LinkedHashMap m = new LinkedHashMap(3);
        m.put(PRIME_FACTOR.getId(), PRIME_FACTOR.applyTo(info.getPrime()));
        m.put(FACTOR_CRT_EXPONENT.getId(), FACTOR_CRT_EXPONENT.applyTo(info.getExponent()));
        m.put(FACTOR_CRT_COEFFICIENT.getId(), FACTOR_CRT_COEFFICIENT.applyTo(info.getCrtCoefficient()));
        return m;
    }

    @Override
    public RSAOtherPrimeInfo applyFrom(Object o) {
        if (o == null) {
            throw new MalformedKeyException("RSA JWK 'oth' (Other Prime Info) element cannot be null.");
        }
        if (!(o instanceof Map)) {
            String msg = "RSA JWK 'oth' (Other Prime Info) must contain map elements of name/value pairs. Element type found: " + o.getClass().getName();
            throw new MalformedKeyException(msg);
        }
        Map m = (Map)o;
        if (Collections.isEmpty(m)) {
            throw new MalformedKeyException("RSA JWK 'oth' (Other Prime Info) element map cannot be empty.");
        }
        DefaultJwkContext<String> ctx = new DefaultJwkContext<String>(PARAMS);
        try {
            for (Map.Entry entry : m.entrySet()) {
                String name = String.valueOf(entry.getKey());
                ctx.put(name, entry.getValue());
            }
        }
        catch (Exception e) {
            throw new MalformedKeyException(e.getMessage(), e);
        }
        RequiredParameterReader reader = new RequiredParameterReader(ctx);
        BigInteger prime = reader.get(PRIME_FACTOR);
        BigInteger primeExponent = reader.get(FACTOR_CRT_EXPONENT);
        BigInteger crtCoefficient = reader.get(FACTOR_CRT_COEFFICIENT);
        return new RSAOtherPrimeInfo(prime, primeExponent, crtCoefficient);
    }
}

