/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECKey;
import org.gcube.io.jsonwebtoken.impl.security.PrivateECKey;
import org.gcube.io.jsonwebtoken.impl.security.ProvidedKeyBuilder;
import org.gcube.io.jsonwebtoken.impl.security.ProviderPrivateKey;
import org.gcube.io.jsonwebtoken.lang.Strings;
import org.gcube.io.jsonwebtoken.security.PrivateKeyBuilder;

public class ProvidedPrivateKeyBuilder
extends ProvidedKeyBuilder<PrivateKey, PrivateKeyBuilder>
implements PrivateKeyBuilder {
    private PublicKey publicKey;

    ProvidedPrivateKeyBuilder(PrivateKey key) {
        super(key);
    }

    @Override
    public PrivateKeyBuilder publicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    @Override
    public PrivateKey doBuild() {
        PrivateKey key = (PrivateKey)this.key;
        String privAlg = Strings.clean(((PrivateKey)this.key).getAlgorithm());
        if (!(key instanceof ECKey) && ("EC".equalsIgnoreCase(privAlg) || "ECDSA".equalsIgnoreCase(privAlg)) && this.publicKey instanceof ECKey) {
            key = new PrivateECKey(key, ((ECKey)((Object)this.publicKey)).getParams());
        }
        return this.provider != null ? new ProviderPrivateKey(this.provider, key) : key;
    }
}

