/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.util.List;
import java.util.Set;
import org.gcube.io.jsonwebtoken.impl.lang.Parameter;
import org.gcube.io.jsonwebtoken.impl.lang.ParameterReadable;
import org.gcube.io.jsonwebtoken.impl.lang.Parameters;
import org.gcube.io.jsonwebtoken.impl.security.AbstractAsymmetricJwk;
import org.gcube.io.jsonwebtoken.impl.security.AbstractPublicJwk;
import org.gcube.io.jsonwebtoken.impl.security.FieldElementConverter;
import org.gcube.io.jsonwebtoken.impl.security.JwkContext;
import org.gcube.io.jsonwebtoken.lang.Collections;
import org.gcube.io.jsonwebtoken.security.EcPublicJwk;
import org.gcube.io.jsonwebtoken.security.PublicJwk;

class DefaultEcPublicJwk
extends AbstractPublicJwk<ECPublicKey>
implements EcPublicJwk {
    static final String TYPE_VALUE = "EC";
    static final Parameter<String> CRV = Parameters.string("crv", "Curve");
    static final Parameter<BigInteger> X = (Parameter)Parameters.bigInt("x", "X Coordinate").setConverter(FieldElementConverter.B64URL_CONVERTER).build();
    static final Parameter<BigInteger> Y = (Parameter)Parameters.bigInt("y", "Y Coordinate").setConverter(FieldElementConverter.B64URL_CONVERTER).build();
    static final Set<Parameter<?>> PARAMS = Collections.concat(AbstractAsymmetricJwk.PARAMS, CRV, X, Y);
    static final List<Parameter<?>> THUMBPRINT_PARAMS = Collections.of(CRV, KTY, X, Y);

    DefaultEcPublicJwk(JwkContext<ECPublicKey> ctx) {
        super(ctx, THUMBPRINT_PARAMS);
    }

    static boolean equalsPublic(ParameterReadable self, Object candidate) {
        return Parameters.equals(self, candidate, CRV) && Parameters.equals(self, candidate, X) && Parameters.equals(self, candidate, Y);
    }

    @Override
    protected boolean equals(PublicJwk<?> jwk) {
        return jwk instanceof EcPublicJwk && DefaultEcPublicJwk.equalsPublic(this, jwk);
    }
}

