/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.compression;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.gcube.io.jsonwebtoken.CompressionCodec;
import org.gcube.io.jsonwebtoken.CompressionException;
import org.gcube.io.jsonwebtoken.impl.io.Streams;
import org.gcube.io.jsonwebtoken.impl.lang.Bytes;
import org.gcube.io.jsonwebtoken.impl.lang.CheckedFunction;
import org.gcube.io.jsonwebtoken.impl.lang.Function;
import org.gcube.io.jsonwebtoken.impl.lang.PropagatingExceptionFunction;
import org.gcube.io.jsonwebtoken.io.CompressionAlgorithm;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Objects;
import org.gcube.io.jsonwebtoken.lang.Strings;

public abstract class AbstractCompressionAlgorithm
implements CompressionAlgorithm,
CompressionCodec {
    private final String id;
    private final Function<OutputStream, OutputStream> OS_WRAP_FN;
    private final Function<InputStream, InputStream> IS_WRAP_FN;
    private final Function<byte[], byte[]> COMPRESS_FN;
    private final Function<byte[], byte[]> DECOMPRESS_FN;

    private static <T, R> Function<T, R> propagate(CheckedFunction<T, R> fn, String msg) {
        return new PropagatingExceptionFunction<T, R, CompressionException>(fn, CompressionException.class, msg);
    }

    private static <T, R> Function<T, R> forCompression(CheckedFunction<T, R> fn) {
        return AbstractCompressionAlgorithm.propagate(fn, "Compression failed.");
    }

    private static <T, R> Function<T, R> forDecompression(CheckedFunction<T, R> fn) {
        return AbstractCompressionAlgorithm.propagate(fn, "Decompression failed.");
    }

    protected AbstractCompressionAlgorithm(String id) {
        this.id = Assert.hasText(Strings.clean(id), "id argument cannot be null or empty.");
        this.OS_WRAP_FN = AbstractCompressionAlgorithm.forCompression(new CheckedFunction<OutputStream, OutputStream>(){

            @Override
            public OutputStream apply(OutputStream out) throws Exception {
                return AbstractCompressionAlgorithm.this.doCompress(out);
            }
        });
        this.COMPRESS_FN = AbstractCompressionAlgorithm.forCompression(new CheckedFunction<byte[], byte[]>(){

            @Override
            public byte[] apply(byte[] data) throws Exception {
                return AbstractCompressionAlgorithm.this.doCompress(data);
            }
        });
        this.IS_WRAP_FN = AbstractCompressionAlgorithm.forDecompression(new CheckedFunction<InputStream, InputStream>(){

            @Override
            public InputStream apply(InputStream is) throws Exception {
                return AbstractCompressionAlgorithm.this.doDecompress(is);
            }
        });
        this.DECOMPRESS_FN = AbstractCompressionAlgorithm.forDecompression(new CheckedFunction<byte[], byte[]>(){

            @Override
            public byte[] apply(byte[] data) throws Exception {
                return AbstractCompressionAlgorithm.this.doDecompress(data);
            }
        });
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getAlgorithmName() {
        return this.getId();
    }

    @Override
    public final OutputStream compress(OutputStream out) throws CompressionException {
        return this.OS_WRAP_FN.apply(out);
    }

    protected abstract OutputStream doCompress(OutputStream var1) throws IOException;

    @Override
    public final InputStream decompress(InputStream is) throws CompressionException {
        return this.IS_WRAP_FN.apply(is);
    }

    protected abstract InputStream doDecompress(InputStream var1) throws IOException;

    @Override
    public final byte[] compress(byte[] content) {
        if (Bytes.isEmpty(content)) {
            return Bytes.EMPTY;
        }
        return this.COMPRESS_FN.apply(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doCompress(byte[] data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        OutputStream compression = this.compress(out);
        try {
            compression.write(data);
            compression.flush();
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(compression);
            throw throwable;
        }
        Objects.nullSafeClose(compression);
        return out.toByteArray();
    }

    @Override
    public final byte[] decompress(byte[] compressed) {
        if (Bytes.isEmpty(compressed)) {
            return Bytes.EMPTY;
        }
        return this.DECOMPRESS_FN.apply(compressed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doDecompress(byte[] compressed) throws IOException {
        InputStream is = Streams.of(compressed);
        InputStream decompress = this.decompress(is);
        byte[] buffer = new byte[512];
        ByteArrayOutputStream out = new ByteArrayOutputStream(buffer.length);
        int read = 0;
        try {
            while (read != -1) {
                read = decompress.read(buffer);
                if (read <= 0) continue;
                out.write(buffer, 0, read);
            }
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(decompress);
            throw throwable;
        }
        Objects.nullSafeClose(decompress);
        return out.toByteArray();
    }
}

