/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.fs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import jnr.ffi.Pointer;
import org.gcube.common.storagehub.client.StreamDescriptor;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.data.access.storagehub.fs.SHFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.serce.jnrfuse.ErrorCodes;
import ru.serce.jnrfuse.struct.FileStat;

public class FileDownload
implements SHFile {
    public static Logger logger = LoggerFactory.getLogger(FileDownload.class);
    AbstractFileItem fileItem;
    File output;
    private long start = System.currentTimeMillis();

    public FileDownload(FileContainer fileContainer) throws Exception {
        StreamDescriptor stream = fileContainer.download(new String[0]);
        this.output = Files.createTempFile("down", stream.getFileName(), new FileAttribute[0]).toFile();
        try (BufferedInputStream bi = new BufferedInputStream(stream.getStream());
             FileOutputStream fo = new FileOutputStream(this.output);){
            byte[] buf = new byte[2046];
            int read = -1;
            while ((read = bi.read(buf)) != -1) {
                fo.write(buf, 0, read);
            }
            fo.flush();
        }
        logger.info("download took {}", (Object)(System.currentTimeMillis() - this.start));
        this.fileItem = (AbstractFileItem)fileContainer.get();
        logger.trace("FILE-DOWNLOAD with {} , {}", (Object)this.fileItem.getName(), (Object)this.fileItem.getContent().getSize());
        logger.trace("output name is {} ans length {}", (Object)this.output.getAbsolutePath(), (Object)this.output.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(Pointer buf, long size, long offset) {
        RandomAccessFile raf = null;
        int bytesToRead = (int)size;
        byte[] mybuf = new byte[bytesToRead];
        int readTotal = 0;
        try {
            raf = new RandomAccessFile(this.output, "r");
            raf.seek(offset);
            int read = 0;
            logger.trace("{} BEFORE: bytes to read {} and read total {} and last read {}", this.fileItem.getName(), bytesToRead, readTotal, read);
            while ((read = raf.read(mybuf, 0, bytesToRead - readTotal)) != -1 && bytesToRead > readTotal) {
                buf.put((long)readTotal, mybuf, 0, read);
                logger.trace("{} INSIDE: bytes to read {} and read total {} and last read {}", this.fileItem.getName(), bytesToRead, readTotal += read, read);
            }
            logger.trace("{} AFTER: bytes to read {} and read total {} and last read {}", this.fileItem.getName(), bytesToRead, readTotal, read);
        }
        catch (Exception e) {
            logger.error("error in read", e);
            int n = -ErrorCodes.ENOENT();
            return n;
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception exception) {}
        }
        logger.trace("{} work finished!!! {}", (Object)this.fileItem.getName(), (Object)readTotal);
        return readTotal;
    }

    @Override
    public int flush() {
        logger.trace("called flush");
        this.output.delete();
        logger.info("file {} took {}", (Object)this.fileItem.getName(), (Object)(System.currentTimeMillis() - this.start));
        return 0;
    }

    @Override
    public int getAttr(FileStat stat) {
        logger.trace("is in download");
        stat.st_mode.set(33133);
        stat.st_size.set(this.fileItem.getContent().getSize());
        stat.st_mtim.tv_sec.set(this.fileItem.getLastModificationTime().toInstant().getEpochSecond());
        stat.st_ctim.tv_sec.set(this.fileItem.getLastModificationTime().toInstant().getEpochSecond());
        stat.st_atim.tv_sec.set(this.fileItem.getLastModificationTime().toInstant().getEpochSecond());
        return 0;
    }

    public File getOutputFile() {
        return this.output;
    }
}

