/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.gxhttp.request;

import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.Map;
import java.util.Objects;
import org.gcube.common.gxhttp.reference.GXConnection;
import org.gcube.common.gxhttp.reference.GXHTTP;
import org.gcube.common.gxhttp.request.GXHTTPCommonRequest;

public class GXHTTPStringRequest
extends GXHTTPCommonRequest
implements GXHTTP<String, HttpURLConnection> {
    private GXHTTPStringRequest(String address) {
        this.builder.connection = new GXConnection(address);
    }

    public static GXHTTPStringRequest newRequest(String address) {
        return new GXHTTPStringRequest(address);
    }

    public GXHTTPStringRequest withBody(String body) {
        this.builder.connection.addBody(body);
        return this;
    }

    @Override
    public HttpURLConnection put(String body) throws Exception {
        if (Objects.nonNull(body)) {
            this.builder.connection.addBody(body);
        }
        logger.trace("Sending a PUT request...");
        return this.builder.connection.send(GXConnection.HTTPMETHOD.PUT);
    }

    @Override
    public HttpURLConnection post(String body) throws Exception {
        logger.trace("Sending a POST request...");
        if (Objects.nonNull(body)) {
            this.builder.connection.addBody(body);
        }
        return this.builder.connection.send(GXConnection.HTTPMETHOD.POST);
    }

    public GXHTTPStringRequest from(String agent) {
        this.builder.from(agent);
        return this;
    }

    public GXHTTPStringRequest path(String path) throws UnsupportedEncodingException {
        this.builder.path(path);
        return this;
    }

    public GXHTTPStringRequest header(String name, String value) {
        this.builder.header(name, value);
        return this;
    }

    public GXHTTPStringRequest queryParams(Map<String, String> queryParams) throws UnsupportedEncodingException {
        this.builder.queryParams(queryParams);
        return this;
    }
}

